/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.plugins.jacoco.XmlReportParser;

public class ReportImporter {
    private final SensorContext ctx;

    public ReportImporter(SensorContext ctx) {
        this.ctx = ctx;
    }

    public void importCoverage(XmlReportParser.SourceFile sourceFile, InputFile inputFile) {
        NewCoverage newCoverage = this.ctx.newCoverage().onFile(inputFile);
        for (XmlReportParser.Line line : sourceFile.lines()) {
            boolean conditions = false;
            if (line.coveredBranches() > 0 || line.missedBranches() > 0) {
                int branches = line.coveredBranches() + line.missedBranches();
                newCoverage.conditions(line.number(), branches, line.coveredBranches());
                conditions = true;
            }
            if (!conditions && line.coveredInstrs() <= 0 && line.missedInstrs() <= 0) continue;
            newCoverage.lineHits(line.number(), line.coveredInstrs() > 0 ? 1 : 0);
        }
        newCoverage.save();
    }
}

