/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.channel;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import java.util.Arrays;
import java.util.Comparator;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.CodeReader;

public class PunctuatorChannel
extends Channel<Lexer> {
    private final int lookahead;
    private final TokenType[] sortedPunctuators;
    private final char[][] sortedPunctuatorsChars;
    private final Token.Builder tokenBuilder = Token.builder();

    public PunctuatorChannel(TokenType ... punctuators) {
        this.sortedPunctuators = punctuators;
        Arrays.sort(this.sortedPunctuators, new PunctuatorComparator());
        this.sortedPunctuatorsChars = new char[this.sortedPunctuators.length][];
        int maxLength = 0;
        for (int i = 0; i < this.sortedPunctuators.length; ++i) {
            this.sortedPunctuatorsChars[i] = this.sortedPunctuators[i].getValue().toCharArray();
            maxLength = Math.max(maxLength, this.sortedPunctuatorsChars[i].length);
        }
        this.lookahead = maxLength;
    }

    @Override
    public boolean consume(CodeReader code, Lexer lexer) {
        char[] next = code.peek(this.lookahead);
        for (int i = 0; i < this.sortedPunctuators.length; ++i) {
            if (!PunctuatorChannel.arraysEquals(next, this.sortedPunctuatorsChars[i])) continue;
            Token token = this.tokenBuilder.setType(this.sortedPunctuators[i]).setValueAndOriginalValue(this.sortedPunctuators[i].getValue()).setURI(lexer.getURI()).setLine(code.getLinePosition()).setColumn(code.getColumnPosition()).build();
            lexer.addToken(token);
            for (int j = 0; j < this.sortedPunctuatorsChars[i].length; ++j) {
                code.pop();
            }
            return true;
        }
        return false;
    }

    private static boolean arraysEquals(char[] a, char[] a2) {
        int length = a2.length;
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    private static class PunctuatorComparator
    implements Comparator<TokenType> {
        private PunctuatorComparator() {
        }

        @Override
        public int compare(TokenType a, TokenType b) {
            if (a.getValue().length() == b.getValue().length()) {
                return 0;
            }
            return a.getValue().length() > b.getValue().length() ? -1 : 1;
        }
    }
}

