/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.pylint.Issue;
import org.sonar.plugins.python.pylint.PylintConfiguration;
import org.sonar.plugins.python.pylint.PylintImportSensor;
import org.sonar.plugins.python.pylint.PylintIssuesAnalyzer;

public class PylintSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(PylintSensor.class);
    private final PylintConfiguration conf;
    private final Configuration settings;
    private PylintIssuesAnalyzer analyzer;

    public PylintSensor(PylintConfiguration conf, Configuration settings) {
        this.conf = conf;
        this.settings = settings;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("PylintSensor").onlyOnLanguage("py").onlyOnFileType(InputFile.Type.MAIN).createIssuesForRuleRepository(new String[]{"Pylint"});
    }

    boolean shouldExecute() {
        return !this.settings.get("sonar.python.pylint.reportPath").isPresent();
    }

    public void execute(SensorContext sensorContext) {
        File workDir = new File(sensorContext.fileSystem().workDir(), "pylint");
        if (!(this.shouldExecute() && PylintSensor.prepareWorkDir(workDir) && this.initializeAnalyzer(sensorContext))) {
            return;
        }
        int i = 0;
        FileSystem fileSystem = sensorContext.fileSystem();
        FilePredicates p = fileSystem.predicates();
        Iterable files = fileSystem.inputFiles(p.and(p.hasType(InputFile.Type.MAIN), p.hasLanguage("py")));
        for (InputFile file : files) {
            try {
                File out = new File(workDir, i + ".out");
                this.analyzeFile(sensorContext, file, out);
                ++i;
            }
            catch (Exception e) {
                LOG.warn("Cannot analyse file '{}', the following exception occurred:", (Object)file.toString(), (Object)e);
            }
        }
    }

    private boolean initializeAnalyzer(SensorContext context) {
        try {
            String pylintConfigPath = this.conf.getPylintConfigPath(context.fileSystem());
            String pylintPath = this.conf.getPylintPath();
            this.analyzer = this.createAnalyzer(pylintConfigPath, pylintPath);
            return true;
        }
        catch (Exception e) {
            LOG.warn("Unable to use pylint for analysis. Error:", (Throwable)e);
            return false;
        }
    }

    PylintIssuesAnalyzer createAnalyzer(String pylintConfigPath, String pylintPath) {
        return new PylintIssuesAnalyzer(pylintPath, pylintConfigPath);
    }

    private void analyzeFile(SensorContext context, InputFile file, File out) throws IOException {
        FileSystem fileSystem = context.fileSystem();
        List<Issue> issues = this.analyzer.analyze(file.absolutePath(), fileSystem.encoding(), out);
        for (Issue pylintIssue : issues) {
            ActiveRule rule = context.activeRules().find(RuleKey.of((String)"Pylint", (String)pylintIssue.getRuleId()));
            PylintImportSensor.processRule(pylintIssue, file, rule, context);
        }
    }

    private static boolean prepareWorkDir(File dir) {
        try {
            FileUtils.forceMkdir(dir);
            FileUtils.cleanDirectory(dir);
            return true;
        }
        catch (IOException e) {
            LOG.warn("Cannot create directory '{}'. Error:", (Object)dir, (Object)e);
            return false;
        }
    }
}

