/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.xunit;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.in.ElementFilter;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.plugins.python.parser.StaxParser;
import org.sonar.plugins.python.xunit.TestCase;
import org.sonar.plugins.python.xunit.TestSuite;

public class TestSuiteParser
implements StaxParser.XmlStreamHandler {
    private List<TestSuite> testSuites = new ArrayList<TestSuite>();

    @Override
    public void stream(SMHierarchicCursor rootCursor) throws XMLStreamException {
        SMInputCursor testSuiteCursor = rootCursor.constructDescendantCursor(new ElementFilter("testsuite"));
        while (testSuiteCursor.getNext() != null) {
            String testSuiteClassName = testSuiteCursor.getAttrValue("name");
            TestSuite testSuite = new TestSuite(testSuiteClassName);
            this.testSuites.add(testSuite);
            SMInputCursor testCaseCursor = testSuiteCursor.childElementCursor("testcase");
            while (testCaseCursor.getNext() != null) {
                testSuite.addTestCase(TestSuiteParser.parseTestCaseTag(testCaseCursor));
            }
        }
    }

    public Collection<TestSuite> getParsedReports() {
        return this.testSuites;
    }

    private static TestCase parseTestCaseTag(SMInputCursor testCaseCursor) throws XMLStreamException {
        String name = TestSuiteParser.parseTestCaseName(testCaseCursor);
        Double time = TestSuiteParser.parseTime(testCaseCursor);
        String status = "ok";
        String stack = "";
        String msg = "";
        String file = testCaseCursor.getAttrValue("file");
        String testClassName = testCaseCursor.getAttrValue("classname");
        SMInputCursor childCursor = testCaseCursor.childElementCursor();
        if (childCursor.getNext() != null) {
            String elementName = childCursor.getLocalName();
            if ("skipped".equals(elementName)) {
                status = "skipped";
            } else if ("failure".equals(elementName)) {
                status = "failure";
                msg = childCursor.getAttrValue("message");
                stack = childCursor.collectDescendantText();
            } else if ("error".equals(elementName)) {
                status = "error";
                msg = childCursor.getAttrValue("message");
                stack = childCursor.collectDescendantText();
            }
        }
        return new TestCase(name, time.intValue(), status, stack, msg, file, testClassName);
    }

    private static double parseTime(SMInputCursor testCaseCursor) throws XMLStreamException {
        double time;
        try {
            Double tmp = ParsingUtils.parseNumber((String)testCaseCursor.getAttrValue("time"), (Locale)Locale.ENGLISH);
            time = ParsingUtils.scaleValue((double)(tmp * 1000.0), (int)3);
        }
        catch (ParseException e) {
            throw new XMLStreamException(e);
        }
        return time;
    }

    private static String parseTestCaseName(SMInputCursor testCaseCursor) throws XMLStreamException {
        String name = testCaseCursor.getAttrValue("name");
        String classname = testCaseCursor.getAttrValue("CLASSNAME");
        if (classname != null) {
            name = classname + "/" + name;
        }
        return name;
    }
}

