/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.Set;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.semantic.Symbol;

public abstract class AbstractCallExpressionCheck
extends PythonCheck {
    protected abstract Set<String> functionsToCheck();

    protected abstract String message();

    protected boolean isException(AstNode callExpression) {
        return false;
    }

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.CALL_EXPR);
    }

    @Override
    public void visitNode(AstNode node) {
        Symbol symbol = this.getContext().symbolTable().getSymbol(node);
        if (!this.isException(node) && symbol != null && this.functionsToCheck().contains(symbol.qualifiedName())) {
            this.addIssue(node, this.message());
        }
    }
}

