/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.python.IssueLocation;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.metrics.CognitiveComplexityVisitor;

@Rule(key="S3776")
public class CognitiveComplexityFunctionCheck
extends PythonCheck {
    private static final String MESSAGE = "Refactor this function to reduce its Cognitive Complexity from %s to the %s allowed.";
    public static final String CHECK_KEY = "S3776";
    private static final int DEFAULT_THRESHOLD = 15;
    @RuleProperty(key="threshold", description="The maximum authorized complexity.", defaultValue="15")
    private int threshold = 15;

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return CognitiveComplexityFunctionCheck.immutableSet(PythonGrammar.FUNCDEF);
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (astNode.hasAncestor((AstNodeType)PythonGrammar.FUNCDEF)) {
            return;
        }
        ArrayList secondaryLocations = new ArrayList();
        int complexity = CognitiveComplexityVisitor.complexity(astNode, (node, message) -> secondaryLocations.add(IssueLocation.preciseLocation(node, message)));
        if (complexity > this.threshold) {
            String message2 = String.format(MESSAGE, complexity, this.threshold);
            PythonCheck.PreciseIssue issue = this.addIssue(astNode.getFirstChild(PythonGrammar.FUNCNAME), message2).withCost(complexity - this.threshold);
            secondaryLocations.forEach(issue::secondary);
        }
    }
}

