/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;

@Rule(key="OneStatementPerLine")
public class OneStatementPerLineCheck
extends PythonCheck {
    public static final String CHECK_KEY = "OneStatementPerLine";
    private final Map<Integer, Integer> statementsPerLine = new HashMap<Integer, Integer>();

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return OneStatementPerLineCheck.immutableSet(PythonGrammar.SIMPLE_STMT, PythonGrammar.SUITE);
    }

    @Override
    public void visitFile(AstNode astNode) {
        this.statementsPerLine.clear();
    }

    @Override
    public void visitNode(AstNode statementNode) {
        int line = statementNode.getTokenLine();
        if (!this.statementsPerLine.containsKey(line)) {
            this.statementsPerLine.put(line, 0);
        }
        this.statementsPerLine.put(line, this.statementsPerLine.get(line) + 1);
    }

    @Override
    public void leaveFile(AstNode astNode) {
        for (Map.Entry<Integer, Integer> statementsAtLine : this.statementsPerLine.entrySet()) {
            if (statementsAtLine.getValue() <= 1) continue;
            String message = String.format("At most one statement is allowed per line, but %s statements were found on this line.", statementsAtLine.getValue());
            int lineNumber = statementsAtLine.getKey();
            this.addLineIssue(message, lineNumber);
        }
    }
}

