/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import javax.servlet.http.HttpServletResponse;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.authentication.AuthenticationRedirection;
import org.sonar.server.authentication.event.AuthenticationException;

final class AuthenticationError {
    private static final String UNAUTHORIZED_PATH = "/sessions/unauthorized";
    private static final String UNAUTHORIZED_PATH_WITH_MESSAGE = "/sessions/unauthorized?message=%s";
    private static final Logger LOGGER = Loggers.get(AuthenticationError.class);

    private AuthenticationError() {
    }

    static void handleError(Exception e, HttpServletResponse response, String message) {
        LOGGER.warn(message, (Throwable)e);
        AuthenticationError.redirectToUnauthorized(response);
    }

    static void handleError(HttpServletResponse response, String message) {
        LOGGER.warn(message);
        AuthenticationError.redirectToUnauthorized(response);
    }

    static void handleAuthenticationError(AuthenticationException e, HttpServletResponse response, String contextPath) {
        AuthenticationRedirection.redirectTo(response, AuthenticationError.getPath(e, contextPath));
    }

    private static String getPath(AuthenticationException e, String contextPath) {
        String publicMessage = e.getPublicMessage();
        if (publicMessage == null || publicMessage.isEmpty()) {
            return UNAUTHORIZED_PATH;
        }
        return contextPath + String.format(UNAUTHORIZED_PATH_WITH_MESSAGE, AuthenticationRedirection.encodeMessage(publicMessage));
    }

    public static void redirectToUnauthorized(HttpServletResponse response) {
        AuthenticationRedirection.redirectTo(response, UNAUTHORIZED_PATH);
    }
}

