/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import javax.annotation.Nullable;
import org.sonar.api.utils.System2;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.db.user.UserTokenDto;
import org.sonar.server.authentication.UserLastConnectionDatesUpdater;

public class UserLastConnectionDatesUpdaterImpl
implements UserLastConnectionDatesUpdater {
    private static final long ONE_HOUR_IN_MILLISECONDS = 3600000L;
    private final DbClient dbClient;
    private final System2 system2;

    public UserLastConnectionDatesUpdaterImpl(DbClient dbClient, System2 system2) {
        this.dbClient = dbClient;
        this.system2 = system2;
    }

    @Override
    public void updateLastConnectionDateIfNeeded(UserDto user) {
        long now;
        Long lastConnectionDate = user.getLastConnectionDate();
        if (UserLastConnectionDatesUpdaterImpl.doesNotRequireUpdate(lastConnectionDate, now = this.system2.now())) {
            return;
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.userDao().update(dbSession, user.setLastConnectionDate(Long.valueOf(now)));
            dbSession.commit();
        }
    }

    @Override
    public void updateLastConnectionDateIfNeeded(UserTokenDto userToken) {
        long now;
        Long lastConnectionDate = userToken.getLastConnectionDate();
        if (UserLastConnectionDatesUpdaterImpl.doesNotRequireUpdate(lastConnectionDate, now = this.system2.now())) {
            return;
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.userTokenDao().update(dbSession, userToken.setLastConnectionDate(Long.valueOf(now)));
            userToken.setLastConnectionDate(Long.valueOf(now));
            dbSession.commit();
        }
    }

    private static boolean doesNotRequireUpdate(@Nullable Long lastConnectionDate, long now) {
        return lastConnectionDate != null && now - lastConnectionDate < 3600000L;
    }
}

