/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.batch;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.batch.BatchIndex;
import org.sonar.server.batch.BatchWsAction;

public class IndexAction
implements BatchWsAction {
    private final BatchIndex batchIndex;

    public IndexAction(BatchIndex batchIndex) {
        this.batchIndex = batchIndex;
    }

    public void define(WebService.NewController context) {
        context.createAction("index").setInternal(true).setSince("4.4").setDescription("List the JAR files to be downloaded by scanners").setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("index-example.txt"));
    }

    public void handle(Request request, Response response) throws Exception {
        try {
            response.stream().setMediaType("text/plain");
            String index = this.batchIndex.getIndex();
            Preconditions.checkState((index != null ? 1 : 0) != 0, (Object)"No available files");
            IOUtils.write((String)index, (OutputStream)response.stream().output(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

