/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.batch;

import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.scanner.protocol.input.FileData;
import org.sonar.scanner.protocol.input.MultiModuleProjectRepository;
import org.sonar.scanner.protocol.input.ProjectRepositories;
import org.sonar.scanner.protocol.input.SingleProjectRepository;
import org.sonar.server.batch.BatchWsAction;
import org.sonar.server.batch.ProjectDataLoader;
import org.sonar.server.batch.ProjectDataQuery;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Batch;

public class ProjectAction
implements BatchWsAction {
    private static final String PARAM_KEY = "key";
    private static final String PARAM_PROFILE = "profile";
    private static final String PARAM_BRANCH = "branch";
    private static final String PARAM_PULL_REQUEST = "pullRequest";
    private final ProjectDataLoader projectDataLoader;

    public ProjectAction(ProjectDataLoader projectDataLoader) {
        this.projectDataLoader = projectDataLoader;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("project").setDescription("Return project repository").setResponseExample(this.getClass().getResource("project-example.json")).setSince("4.5").setChangelog(new Change[]{new Change("7.6", String.format("The use of module keys in parameter '%s' is deprecated", PARAM_KEY))}).setChangelog(new Change[]{new Change("7.6", "Stop returning settings")}).setChangelog(new Change[]{new Change("7.7", "Stop supporting preview mode, removed timestamp and last analysis date")}).setInternal(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_KEY).setRequired(true).setDescription("Project or module key").setExampleValue((Object)"my_project");
        action.createParam(PARAM_PROFILE).setDescription("Profile name").setExampleValue((Object)"SonarQube Way");
        action.createParam(PARAM_BRANCH).setSince("6.6").setDescription("Branch key").setExampleValue((Object)"feature/my_branch");
        action.createParam(PARAM_PULL_REQUEST).setSince("7.1").setDescription("Pull request id").setExampleValue((Object)"5461");
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        ProjectRepositories data = this.projectDataLoader.load(ProjectDataQuery.create().setProjectKey(wsRequest.mandatoryParam(PARAM_KEY)).setProfileName(wsRequest.param(PARAM_PROFILE)).setBranch(wsRequest.param(PARAM_BRANCH)).setPullRequest(wsRequest.param(PARAM_PULL_REQUEST)));
        Batch.WsProjectResponse projectResponse = ProjectAction.buildResponse(data);
        WsUtils.writeProtobuf((Message)projectResponse, wsRequest, wsResponse);
    }

    private static Batch.WsProjectResponse buildResponse(ProjectRepositories data) {
        Batch.WsProjectResponse.Builder response = Batch.WsProjectResponse.newBuilder();
        if (data instanceof SingleProjectRepository) {
            response.putAllFileDataByPath(ProjectAction.buildFileDataByPath((SingleProjectRepository)data));
        } else {
            response.putAllFileDataByModuleAndPath(ProjectAction.buildFileDataByModuleAndPath((MultiModuleProjectRepository)data));
        }
        return response.build();
    }

    private static Map<String, Batch.WsProjectResponse.FileDataByPath> buildFileDataByModuleAndPath(MultiModuleProjectRepository data) {
        return data.repositoriesByModule().entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), (Object)ProjectAction.buildFileDataByPath(((SingleProjectRepository)entry.getValue()).fileData()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<String, Batch.WsProjectResponse.FileData> buildFileDataByPath(SingleProjectRepository data) {
        return data.fileData().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ProjectAction.toFileDataResponse((FileData)e.getValue())));
    }

    private static Batch.WsProjectResponse.FileDataByPath buildFileDataByPath(Map<String, FileData> fileDataByPath) {
        Batch.WsProjectResponse.FileDataByPath.Builder response = Batch.WsProjectResponse.FileDataByPath.newBuilder();
        fileDataByPath.forEach((key, value) -> response.putFileDataByPath(key, ProjectAction.toFileDataResponse(value)));
        return response.build();
    }

    private static Batch.WsProjectResponse.FileData toFileDataResponse(FileData fileData) {
        Batch.WsProjectResponse.FileData.Builder fileDataBuilder = Batch.WsProjectResponse.FileData.newBuilder();
        Optional.ofNullable(fileData.hash()).ifPresent(arg_0 -> ((Batch.WsProjectResponse.FileData.Builder)fileDataBuilder).setHash(arg_0));
        Optional.ofNullable(fileData.revision()).ifPresent(arg_0 -> ((Batch.WsProjectResponse.FileData.Builder)fileDataBuilder).setRevision(arg_0));
        return fileDataBuilder.build();
    }
}

