/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component;

import java.util.Collections;
import java.util.Set;
import org.sonar.api.server.ServerSide;
import org.sonar.core.component.ComponentKeys;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentKeyUpdaterDao;
import org.sonar.db.component.ResourceDto;
import org.sonar.server.es.ProjectIndexer;
import org.sonar.server.es.ProjectIndexers;
import org.sonar.server.project.Project;
import org.sonar.server.project.ProjectLifeCycleListeners;
import org.sonar.server.project.RekeyedProject;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class ComponentService {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ProjectIndexers projectIndexers;
    private final ProjectLifeCycleListeners projectLifeCycleListeners;

    public ComponentService(DbClient dbClient, UserSession userSession, ProjectIndexers projectIndexers, ProjectLifeCycleListeners projectLifeCycleListeners) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.projectIndexers = projectIndexers;
        this.projectLifeCycleListeners = projectLifeCycleListeners;
    }

    public void updateKey(DbSession dbSession, ComponentDto projectOrModule, String newKey) {
        this.userSession.checkComponentPermission("admin", projectOrModule);
        ComponentKeyUpdaterDao.checkIsProjectOrModule((ComponentDto)projectOrModule);
        ComponentService.checkProjectOrModuleKeyFormat(newKey);
        this.dbClient.componentKeyUpdaterDao().updateKey(dbSession, projectOrModule.uuid(), newKey);
        this.projectIndexers.commitAndIndex(dbSession, Collections.singletonList(projectOrModule), ProjectIndexer.Cause.PROJECT_KEY_UPDATE);
        if (ComponentService.isMainProject(projectOrModule)) {
            Project newProject = new Project(projectOrModule.uuid(), newKey, projectOrModule.name(), projectOrModule.description(), projectOrModule.getTags());
            this.projectLifeCycleListeners.onProjectsRekeyed(Collections.singleton(new RekeyedProject(newProject, projectOrModule.getDbKey())));
        }
    }

    private static boolean isMainProject(ComponentDto projectOrModule) {
        return projectOrModule.isRootProject() && projectOrModule.getMainBranchProjectUuid() == null;
    }

    public void bulkUpdateKey(DbSession dbSession, ComponentDto projectOrModule, String stringToReplace, String replacementString) {
        Set rekeyedProjects = this.dbClient.componentKeyUpdaterDao().bulkUpdateKey(dbSession, projectOrModule.uuid(), stringToReplace, replacementString, ComponentService::isMainProject);
        this.projectIndexers.commitAndIndex(dbSession, Collections.singletonList(projectOrModule), ProjectIndexer.Cause.PROJECT_KEY_UPDATE);
        if (!rekeyedProjects.isEmpty()) {
            this.projectLifeCycleListeners.onProjectsRekeyed((Set)rekeyedProjects.stream().map(ComponentService::toRekeyedProject).collect(MoreCollectors.toSet((int)rekeyedProjects.size())));
        }
    }

    private static boolean isMainProject(ComponentKeyUpdaterDao.RekeyedResource rekeyedResource) {
        ResourceDto resource = rekeyedResource.getResource();
        String resourceKey = resource.getKey();
        return "PRJ".equals(resource.getScope()) && "TRK".equals(resource.getQualifier()) && !resourceKey.contains(":BRANCH:") && !resourceKey.contains(":PULL_REQUEST:");
    }

    private static RekeyedProject toRekeyedProject(ComponentKeyUpdaterDao.RekeyedResource rekeyedResource) {
        ResourceDto resource = rekeyedResource.getResource();
        Project project = new Project(resource.getUuid(), resource.getKey(), resource.getName(), resource.getDescription(), Collections.emptyList());
        return new RekeyedProject(project, rekeyedResource.getOldKey());
    }

    private static void checkProjectOrModuleKeyFormat(String key) {
        WsUtils.checkRequest(ComponentKeys.isValidProjectKey((String)key), "Malformed key for '%s'. Allowed characters are alphanumeric, '-', '_', '.' and ':', with at least one non-digit.", key);
    }
}

