/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.index;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class ComponentQuery {
    private final String organizationUuid;
    private final String query;
    private final Collection<String> qualifiers;
    private final String language;

    private ComponentQuery(Builder builder) {
        this.organizationUuid = builder.organizationUuid;
        this.query = builder.query;
        this.qualifiers = builder.qualifiers;
        this.language = builder.language;
    }

    @CheckForNull
    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    @CheckForNull
    public String getQuery() {
        return this.query;
    }

    public Collection<String> getQualifiers() {
        return this.qualifiers;
    }

    @CheckForNull
    public String getLanguage() {
        return this.language;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String organizationUuid;
        private String query;
        private Collection<String> qualifiers = Collections.emptySet();
        private String language;

        private Builder() {
        }

        public Builder setOrganization(@Nullable String organizationUuid) {
            this.organizationUuid = organizationUuid;
            return this;
        }

        public Builder setQuery(@Nullable String query) {
            this.query = query;
            return this;
        }

        public Builder setQualifiers(Collection<String> qualifiers) {
            this.qualifiers = Collections.unmodifiableCollection(qualifiers);
            return this;
        }

        public Builder setLanguage(@Nullable String language) {
            this.language = language;
            return this;
        }

        public ComponentQuery build() {
            return new ComponentQuery(this);
        }
    }
}

