/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.measure.ProjectMeasuresIndexerIterator;
import org.sonar.server.measure.index.ProjectMeasuresQuery;

public class ProjectMeasuresQueryValidator {
    static final Set<String> NON_METRIC_SORT_KEYS = new HashSet<String>(Arrays.asList("name", "analysisDate"));

    private ProjectMeasuresQueryValidator() {
    }

    public static void validate(ProjectMeasuresQuery query) {
        ProjectMeasuresQueryValidator.validateFilterKeys((Set)query.getMetricCriteria().stream().map(ProjectMeasuresQuery.MetricCriterion::getMetricKey).collect(MoreCollectors.toHashSet()));
        ProjectMeasuresQueryValidator.validateSort(query.getSort());
    }

    private static void validateFilterKeys(Set<String> metricsKeys) {
        String invalidKeys = metricsKeys.stream().filter(metric -> !ProjectMeasuresIndexerIterator.METRIC_KEYS.contains(metric)).map(metric -> '\'' + metric + '\'').collect(Collectors.joining(", "));
        Preconditions.checkArgument((boolean)invalidKeys.isEmpty(), (String)"Following metrics are not supported: %s", (Object[])new Object[]{invalidKeys});
    }

    private static void validateSort(@Nullable String sort) {
        if (sort == null) {
            return;
        }
        if (NON_METRIC_SORT_KEYS.contains(sort)) {
            return;
        }
        ProjectMeasuresQueryValidator.validateFilterKeys(Collections.singleton(sort));
    }
}

