/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.component.ws.ComponentDtoToWsComponent;
import org.sonar.server.component.ws.ComponentsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Components;

public class ShowAction
implements ComponentsWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;

    public ShowAction(UserSession userSession, DbClient dbClient, ComponentFinder componentFinder) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("show").setDescription(String.format("Returns a component (file, directory, project, view\u2026) and its ancestors. The ancestors are ordered from the parent to the root project. The '%s' or '%s' parameter must be provided.<br>Requires the following permission: 'Browse' on the project of the specified component.", "componentId", "component")).setResponseExample(this.getClass().getResource("show-example.json")).setSince("5.4").setChangelog(new Change[]{new Change("6.4", "Analysis date has been added to the response"), new Change("6.4", "The field 'id' is deprecated in the response"), new Change("6.4", "The 'visibility' field is added to the response"), new Change("6.5", "Leak period date is added to the response"), new Change("6.6", "'branch' is added to the response"), new Change("6.6", "'version' is added to the response"), new Change("7.6", String.format("The use of module keys in parameter '%s' is deprecated", "component"))}).setHandler((RequestHandler)this);
        action.createParam("componentId").setDescription("Component id").setDeprecatedKey("id", "6.4").setDeprecatedSince("6.4").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("component").setDescription("Component key").setDeprecatedKey("key", "6.4").setExampleValue((Object)"my_project");
        action.createParam("branch").setDescription("Branch key").setExampleValue((Object)"feature/my_branch").setInternal(true).setSince("6.6");
        action.createParam("pullRequest").setDescription("Pull request id").setExampleValue((Object)"5461").setInternal(true).setSince("7.1");
    }

    public void handle(org.sonar.api.server.ws.Request request, Response response) throws Exception {
        Request showRequest = ShowAction.toShowWsRequest(request);
        Components.ShowWsResponse showWsResponse = this.doHandle(showRequest);
        WsUtils.writeProtobuf((Message)showWsResponse, request, response);
    }

    private Components.ShowWsResponse doHandle(Request request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.loadComponent(dbSession, request);
            this.userSession.checkComponentPermission("user", component);
            Optional lastAnalysis = this.dbClient.snapshotDao().selectLastAnalysisByComponentUuid(dbSession, component.projectUuid());
            List ancestors = this.dbClient.componentDao().selectAncestors(dbSession, component);
            OrganizationDto organizationDto = this.componentFinder.getOrganization(dbSession, component);
            Components.ShowWsResponse showWsResponse = ShowAction.buildResponse(component, organizationDto, ancestors, lastAnalysis);
            return showWsResponse;
        }
    }

    private ComponentDto loadComponent(DbSession dbSession, Request request) {
        String componentId = request.getId();
        String componentKey = request.getKey();
        String branch = request.getBranch();
        String pullRequest = request.getPullRequest();
        Preconditions.checkArgument((componentId == null || branch == null && pullRequest == null ? 1 : 0) != 0, (String)"Parameter '%s' cannot be used at the same time as '%s' or '%s'", (Object[])new Object[]{"componentId", "branch", "pullRequest"});
        if (branch == null && pullRequest == null) {
            return this.componentFinder.getByUuidOrKey(dbSession, componentId, componentKey, ComponentFinder.ParamNames.COMPONENT_ID_AND_COMPONENT);
        }
        WsUtils.checkRequest(componentKey != null, "The '%s' parameter is missing", "component");
        return this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, componentKey, branch, pullRequest);
    }

    private static Components.ShowWsResponse buildResponse(ComponentDto component, OrganizationDto organizationDto, List<ComponentDto> orderedAncestors, Optional<SnapshotDto> lastAnalysis) {
        Components.ShowWsResponse.Builder response = Components.ShowWsResponse.newBuilder();
        response.setComponent(ComponentDtoToWsComponent.componentDtoToWsComponent(component, organizationDto, lastAnalysis));
        int size = orderedAncestors.size() - 1;
        IntStream.rangeClosed(0, size).forEach(index -> response.addAncestors(ComponentDtoToWsComponent.componentDtoToWsComponent((ComponentDto)orderedAncestors.get(size - index), organizationDto, lastAnalysis)));
        return response.build();
    }

    private static Request toShowWsRequest(org.sonar.api.server.ws.Request request) {
        return new Request().setId(request.param("componentId")).setKey(request.param("component")).setBranch(request.param("branch")).setPullRequest(request.param("pullRequest"));
    }

    private static class Request {
        private String id;
        private String key;
        private String branch;
        private String pullRequest;

        private Request() {
        }

        @CheckForNull
        public String getId() {
            return this.id;
        }

        public Request setId(@Nullable String id) {
            this.id = id;
            return this;
        }

        @CheckForNull
        public String getKey() {
            return this.key;
        }

        public Request setKey(@Nullable String key) {
            this.key = key;
            return this;
        }

        @CheckForNull
        public String getBranch() {
            return this.branch;
        }

        public Request setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        @CheckForNull
        public String getPullRequest() {
            return this.pullRequest;
        }

        public Request setPullRequest(@Nullable String pullRequest) {
            this.pullRequest = pullRequest;
            return this;
        }
    }
}

