/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.html.HtmlEscapers;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.component.index.ComponentHit;
import org.sonar.server.component.index.ComponentHitsPerQualifier;
import org.sonar.server.component.index.ComponentIndex;
import org.sonar.server.component.index.ComponentIndexResults;
import org.sonar.server.component.index.SuggestionQuery;
import org.sonar.server.component.ws.ComponentsWsAction;
import org.sonar.server.component.ws.SuggestionCategory;
import org.sonar.server.favorite.FavoriteFinder;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Components;

public class SuggestionsAction
implements ComponentsWsAction {
    static final String PARAM_QUERY = "s";
    static final String PARAM_MORE = "more";
    static final String PARAM_RECENTLY_BROWSED = "recentlyBrowsed";
    static final String SHORT_INPUT_WARNING = "short_input";
    private static final int MAXIMUM_RECENTLY_BROWSED = 50;
    private static final int EXTENDED_LIMIT = 20;
    private static final Set<String> QUALIFIERS_FOR_WHICH_TO_RETURN_PROJECT = Stream.of("FIL", "UTS").collect(Collectors.toSet());
    private final ComponentIndex index;
    private final FavoriteFinder favoriteFinder;
    private final UserSession userSession;
    private final ResourceTypes resourceTypes;
    private DbClient dbClient;

    public SuggestionsAction(DbClient dbClient, ComponentIndex index, FavoriteFinder favoriteFinder, UserSession userSession, ResourceTypes resourceTypes) {
        this.dbClient = dbClient;
        this.index = index;
        this.favoriteFinder = favoriteFinder;
        this.userSession = userSession;
        this.resourceTypes = resourceTypes;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("suggestions").setDescription("Internal WS for the top-right search engine. The result will contain component search results, grouped by their qualifiers.<p>Each result contains:<ul><li>the organization key</li><li>the component key</li><li>the component's name (unescaped)</li><li>optionally a display name, which puts emphasis to matching characters (this text contains html tags and parts of the html-escaped name)</li></ul>").setSince("4.2").setInternal(true).setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"suggestions-example.json")).setChangelog(new Change[]{new Change("7.6", String.format("The use of 'BRC' as value for parameter '%s' is deprecated", PARAM_MORE)), new Change("6.4", "Parameter 's' is optional")});
        action.createParam(PARAM_QUERY).setRequired(false).setMinimumLength(Integer.valueOf(2)).setDescription("Search query: can contain several search tokens separated by spaces.").setExampleValue((Object)"sonar");
        action.createParam(PARAM_MORE).setDescription("Category, for which to display the next 20 results (skipping the first 6 results)").setPossibleValues((Object[])Arrays.stream(SuggestionCategory.values()).map(SuggestionCategory::getName).toArray(String[]::new)).setSince("6.4");
        action.createParam(PARAM_RECENTLY_BROWSED).setDescription("Comma separated list of component keys, that have recently been browsed by the user. Only the first 50 items will be used. Order is not taken into account.").setSince("6.4").setExampleValue((Object)"org.sonarsource:sonarqube,some.other:project").setRequired(false).setMaxValuesAllowed(Integer.valueOf(50));
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        String query = wsRequest.param(PARAM_QUERY);
        String more = wsRequest.param(PARAM_MORE);
        Set<String> recentlyBrowsedKeys = SuggestionsAction.getRecentlyBrowsedKeys(wsRequest);
        List<String> qualifiers = this.getQualifiers(more);
        int skip = more == null ? 0 : 6;
        int limit = more == null ? 6 : 20;
        Components.SuggestionsWsResponse searchWsResponse = this.loadSuggestions(query, skip, limit, recentlyBrowsedKeys, qualifiers);
        WsUtils.writeProtobuf((Message)searchWsResponse, wsRequest, wsResponse);
    }

    private static Set<String> getRecentlyBrowsedKeys(Request wsRequest) {
        List recentlyBrowsedParam = wsRequest.paramAsStrings(PARAM_RECENTLY_BROWSED);
        if (recentlyBrowsedParam == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(recentlyBrowsedParam);
    }

    private Components.SuggestionsWsResponse loadSuggestions(@Nullable String query, int skip, int limit, Set<String> recentlyBrowsedKeys, List<String> qualifiers) {
        if (query == null) {
            return this.loadSuggestionsWithoutSearch(skip, limit, recentlyBrowsedKeys, qualifiers);
        }
        return this.loadSuggestionsWithSearch(query, skip, limit, recentlyBrowsedKeys, qualifiers);
    }

    private Components.SuggestionsWsResponse loadSuggestionsWithoutSearch(int skip, int limit, Set<String> recentlyBrowsedKeys, List<String> qualifiers) {
        List<ComponentDto> favoriteDtos = this.favoriteFinder.list();
        if (favoriteDtos.isEmpty() && recentlyBrowsedKeys.isEmpty()) {
            return Components.SuggestionsWsResponse.newBuilder().build();
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List<ComponentDto> authorizedComponents;
            ListMultimap componentsPerQualifier;
            HashSet<ComponentDto> componentDtos = new HashSet<ComponentDto>(favoriteDtos);
            if (!recentlyBrowsedKeys.isEmpty()) {
                componentDtos.addAll(this.dbClient.componentDao().selectByKeys(dbSession, recentlyBrowsedKeys));
            }
            if ((componentsPerQualifier = (ListMultimap)(authorizedComponents = this.userSession.keepAuthorizedComponents("user", componentDtos)).stream().collect(MoreCollectors.index(ComponentDto::qualifier))).isEmpty()) {
                Components.SuggestionsWsResponse suggestionsWsResponse = Components.SuggestionsWsResponse.newBuilder().build();
                return suggestionsWsResponse;
            }
            Set favoriteUuids = (Set)favoriteDtos.stream().map(ComponentDto::uuid).collect(MoreCollectors.toSet((int)favoriteDtos.size()));
            Comparator<ComponentDto> favoriteComparator = Comparator.comparing(c -> favoriteUuids.contains(c.uuid()) ? -1 : 1);
            Comparator<ComponentDto> comparator = favoriteComparator.thenComparing(ComponentDto::name);
            ComponentIndexResults componentsPerQualifiers = ComponentIndexResults.newBuilder().setQualifiers(qualifiers.stream().map(q -> {
                List componentsOfThisQualifier = componentsPerQualifier.get(q);
                List hits = (List)componentsOfThisQualifier.stream().sorted(comparator).skip(skip).limit(limit).map(ComponentDto::uuid).map(ComponentHit::new).collect(MoreCollectors.toList((int)limit));
                int totalHits = componentsOfThisQualifier.size();
                return new ComponentHitsPerQualifier(q, hits, (long)totalHits);
            })).build();
            Components.SuggestionsWsResponse suggestionsWsResponse = this.buildResponse(recentlyBrowsedKeys, favoriteUuids, componentsPerQualifiers, dbSession, authorizedComponents, skip + limit).build();
            return suggestionsWsResponse;
        }
    }

    private Components.SuggestionsWsResponse loadSuggestionsWithSearch(String query, int skip, int limit, Set<String> recentlyBrowsedKeys, List<String> qualifiers) {
        if (SuggestionsAction.split(query).noneMatch(token -> token.length() >= 2)) {
            Components.SuggestionsWsResponse.Builder queryBuilder = Components.SuggestionsWsResponse.newBuilder();
            SuggestionsAction.getWarning(query).ifPresent(arg_0 -> ((Components.SuggestionsWsResponse.Builder)queryBuilder).setWarning(arg_0));
            return queryBuilder.build();
        }
        List<ComponentDto> favorites = this.favoriteFinder.list();
        Set favoriteKeys = (Set)favorites.stream().map(ComponentDto::getDbKey).collect(MoreCollectors.toSet((int)favorites.size()));
        SuggestionQuery.Builder queryBuilder = SuggestionQuery.builder().setQuery(query).setRecentlyBrowsedKeys(recentlyBrowsedKeys).setFavoriteKeys(favoriteKeys).setQualifiers(qualifiers).setSkip(skip).setLimit(limit);
        ComponentIndexResults componentsPerQualifiers = this.searchInIndex(queryBuilder.build());
        if (componentsPerQualifiers.isEmpty()) {
            return Components.SuggestionsWsResponse.newBuilder().build();
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Set componentUuids = (Set)componentsPerQualifiers.getQualifiers().map(ComponentHitsPerQualifier::getHits).flatMap(Collection::stream).map(ComponentHit::getUuid).collect(MoreCollectors.toSet());
            List componentDtos = this.dbClient.componentDao().selectByUuids(dbSession, (Collection)componentUuids);
            Set favoriteUuids = (Set)favorites.stream().map(ComponentDto::uuid).collect(MoreCollectors.toSet((int)favorites.size()));
            Components.SuggestionsWsResponse.Builder searchWsResponse = this.buildResponse(recentlyBrowsedKeys, favoriteUuids, componentsPerQualifiers, dbSession, componentDtos, skip + limit);
            SuggestionsAction.getWarning(query).ifPresent(arg_0 -> ((Components.SuggestionsWsResponse.Builder)searchWsResponse).setWarning(arg_0));
            Components.SuggestionsWsResponse suggestionsWsResponse = searchWsResponse.build();
            return suggestionsWsResponse;
        }
    }

    private static Optional<String> getWarning(String query) {
        return SuggestionsAction.split(query).filter(token -> token.length() < 2).findAny().map(x -> SHORT_INPUT_WARNING);
    }

    private static Stream<String> split(String query) {
        return Arrays.stream(query.split("[\\s]+"));
    }

    private List<String> getQualifiers(@Nullable String more) {
        Set availableQualifiers = (Set)this.resourceTypes.getAll().stream().map(ResourceType::getQualifier).filter(q -> !q.equals("BRC")).collect(MoreCollectors.toSet());
        if (more == null) {
            return Arrays.stream(SuggestionCategory.values()).map(SuggestionCategory::getQualifier).filter(availableQualifiers::contains).collect(Collectors.toList());
        }
        String qualifier = SuggestionCategory.getByName(more).getQualifier();
        return availableQualifiers.contains(qualifier) ? Collections.singletonList(qualifier) : Collections.emptyList();
    }

    private Components.SuggestionsWsResponse.Builder buildResponse(Set<String> recentlyBrowsedKeys, Set<String> favoriteUuids, ComponentIndexResults componentsPerQualifiers, DbSession dbSession, List<ComponentDto> componentDtos, int coveredItems) {
        Map componentsByUuids = (Map)componentDtos.stream().collect(MoreCollectors.uniqueIndex(ComponentDto::uuid));
        Map<String, OrganizationDto> organizationsByUuids = this.loadOrganizations(dbSession, componentsByUuids.values());
        Map<String, ComponentDto> projectsByUuids = this.loadProjects(dbSession, componentsByUuids.values());
        return SuggestionsAction.toResponse(componentsPerQualifiers, recentlyBrowsedKeys, favoriteUuids, organizationsByUuids, componentsByUuids, projectsByUuids, coveredItems);
    }

    private Map<String, ComponentDto> loadProjects(DbSession dbSession, Collection<ComponentDto> components) {
        Set projectUuids = (Set)components.stream().filter(c -> QUALIFIERS_FOR_WHICH_TO_RETURN_PROJECT.contains(c.qualifier())).map(ComponentDto::projectUuid).collect(MoreCollectors.toSet());
        return (Map)this.dbClient.componentDao().selectByUuids(dbSession, (Collection)projectUuids).stream().collect(MoreCollectors.uniqueIndex(ComponentDto::uuid));
    }

    private Map<String, OrganizationDto> loadOrganizations(DbSession dbSession, Collection<ComponentDto> components) {
        Set organizationUuids = (Set)components.stream().map(ComponentDto::getOrganizationUuid).collect(MoreCollectors.toSet());
        return (Map)this.dbClient.organizationDao().selectByUuids(dbSession, organizationUuids).stream().collect(MoreCollectors.uniqueIndex(OrganizationDto::getUuid));
    }

    private ComponentIndexResults searchInIndex(SuggestionQuery suggestionQuery) {
        return this.index.searchSuggestions(suggestionQuery);
    }

    private static Components.SuggestionsWsResponse.Builder toResponse(ComponentIndexResults componentsPerQualifiers, Set<String> recentlyBrowsedKeys, Set<String> favoriteUuids, Map<String, OrganizationDto> organizationsByUuids, Map<String, ComponentDto> componentsByUuids, Map<String, ComponentDto> projectsByUuids, int coveredItems) {
        if (componentsPerQualifiers.isEmpty()) {
            return Components.SuggestionsWsResponse.newBuilder();
        }
        return Components.SuggestionsWsResponse.newBuilder().addAllResults(SuggestionsAction.toCategories(componentsPerQualifiers, recentlyBrowsedKeys, favoriteUuids, componentsByUuids, organizationsByUuids, projectsByUuids, coveredItems)).addAllOrganizations(SuggestionsAction.toOrganizations(organizationsByUuids)).addAllProjects(SuggestionsAction.toProjects(projectsByUuids));
    }

    private static List<Components.SuggestionsWsResponse.Category> toCategories(ComponentIndexResults componentsPerQualifiers, Set<String> recentlyBrowsedKeys, Set<String> favoriteUuids, Map<String, ComponentDto> componentsByUuids, Map<String, OrganizationDto> organizationByUuids, Map<String, ComponentDto> projectsByUuids, int coveredItems) {
        return (List)componentsPerQualifiers.getQualifiers().map(qualifier -> {
            List suggestions = (List)qualifier.getHits().stream().map(hit -> SuggestionsAction.toSuggestion(hit, recentlyBrowsedKeys, favoriteUuids, componentsByUuids, organizationByUuids, projectsByUuids)).filter(Objects::nonNull).collect(MoreCollectors.toList());
            return Components.SuggestionsWsResponse.Category.newBuilder().setQ(qualifier.getQualifier()).setMore(Math.max(0L, qualifier.getTotalHits() - (long)coveredItems)).addAllItems((Iterable)suggestions).build();
        }).collect(MoreCollectors.toList());
    }

    @CheckForNull
    private static Components.SuggestionsWsResponse.Suggestion toSuggestion(ComponentHit hit, Set<String> recentlyBrowsedKeys, Set<String> favoriteUuids, Map<String, ComponentDto> componentsByUuids, Map<String, OrganizationDto> organizationByUuids, Map<String, ComponentDto> projectsByUuids) {
        ComponentDto result = componentsByUuids.get(hit.getUuid());
        if (result == null || QUALIFIERS_FOR_WHICH_TO_RETURN_PROJECT.contains(result.qualifier()) && projectsByUuids.get(result.projectUuid()) == null) {
            return null;
        }
        String organizationKey = organizationByUuids.get(result.getOrganizationUuid()).getKey();
        Preconditions.checkState((organizationKey != null ? 1 : 0) != 0, (String)"Organization with uuid '%s' not found", (Object[])new Object[]{result.getOrganizationUuid()});
        Components.SuggestionsWsResponse.Suggestion.Builder builder = Components.SuggestionsWsResponse.Suggestion.newBuilder().setOrganization(organizationKey).setKey(result.getDbKey()).setName(result.name()).setMatch(hit.getHighlightedText().orElse(HtmlEscapers.htmlEscaper().escape(result.name()))).setIsRecentlyBrowsed(recentlyBrowsedKeys.contains(result.getDbKey())).setIsFavorite(favoriteUuids.contains(result.uuid()));
        if (QUALIFIERS_FOR_WHICH_TO_RETURN_PROJECT.contains(result.qualifier())) {
            builder.setProject(projectsByUuids.get(result.projectUuid()).getDbKey());
        }
        return builder.build();
    }

    private static List<Common.Organization> toOrganizations(Map<String, OrganizationDto> organizationByUuids) {
        return organizationByUuids.values().stream().map(o -> Common.Organization.newBuilder().setKey(o.getKey()).setName(o.getName()).build()).collect(Collectors.toList());
    }

    private static List<Components.SuggestionsWsResponse.Project> toProjects(Map<String, ComponentDto> projectsByUuids) {
        return projectsByUuids.values().stream().map(p -> Components.SuggestionsWsResponse.Project.newBuilder().setKey(p.getDbKey()).setName(p.longName()).build()).collect(Collectors.toList());
    }
}

