/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.exceptions;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class Message {
    private final String msg;

    private Message(String format, Object ... params) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)format) ? 1 : 0) != 0, (Object)"Message cannot be empty");
        this.msg = String.format(format, params);
    }

    public String getMessage() {
        return this.msg;
    }

    public static Message of(String msg, Object ... arguments) {
        return new Message(msg, arguments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message other = (Message)o;
        return this.msg.equals(other.msg);
    }

    public int hashCode() {
        return this.msg.hashCode();
    }

    public String toString() {
        return this.msg;
    }
}

