/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.health;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sonar.process.cluster.health.NodeHealth;
import org.sonar.server.health.Health;

public class ClusterHealth {
    private final Health health;
    private final Set<NodeHealth> nodes;

    public ClusterHealth(Health health, Set<NodeHealth> nodes) {
        this.health = Objects.requireNonNull(health, "health can't be null");
        this.nodes = ImmutableSet.copyOf((Collection)Objects.requireNonNull(nodes, "nodes can't be null"));
    }

    public Health getHealth() {
        return this.health;
    }

    public Set<NodeHealth> getNodes() {
        return this.nodes;
    }

    public Optional<NodeHealth> getNodeHealth(String nodeName) {
        return this.nodes.stream().filter(node -> nodeName.equals(node.getDetails().getName())).findFirst();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterHealth that = (ClusterHealth)o;
        return Objects.equals(this.health, that.health) && Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.health, this.nodes);
    }

    public String toString() {
        return "ClusterHealth{health=" + this.health + ", nodes=" + this.nodes + '}';
    }
}

