/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.health;

import java.util.EnumSet;
import org.sonar.server.app.RestartFlagHolder;
import org.sonar.server.health.Health;
import org.sonar.server.health.NodeHealthCheck;
import org.sonar.server.platform.Platform;
import org.sonar.server.platform.db.migration.DatabaseMigrationState;

public class WebServerStatusNodeCheck
implements NodeHealthCheck {
    private static final EnumSet<DatabaseMigrationState.Status> VALID_DATABASEMIGRATION_STATUSES = EnumSet.of(DatabaseMigrationState.Status.NONE, DatabaseMigrationState.Status.SUCCEEDED);
    private final DatabaseMigrationState migrationState;
    private final Platform platform;
    private final RestartFlagHolder restartFlagHolder;

    public WebServerStatusNodeCheck(DatabaseMigrationState migrationState, Platform platform, RestartFlagHolder restartFlagHolder) {
        this.migrationState = migrationState;
        this.platform = platform;
        this.restartFlagHolder = restartFlagHolder;
    }

    @Override
    public Health check() {
        Platform.Status platformStatus = this.platform.status();
        if (platformStatus == Platform.Status.UP && VALID_DATABASEMIGRATION_STATUSES.contains(this.migrationState.getStatus()) && !this.restartFlagHolder.isRestarting()) {
            return Health.GREEN;
        }
        return Health.newHealthCheckBuilder().setStatus(Health.Status.RED).addCause("SonarQube webserver is not up").build();
    }
}

