/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.notifications.Notification;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.issue.IssueChangePostProcessor;
import org.sonar.server.issue.WebIssueStorage;
import org.sonar.server.issue.notification.IssueChangeNotification;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.notification.NotificationManager;

public class IssueUpdater {
    private final DbClient dbClient;
    private final WebIssueStorage issueStorage;
    private final NotificationManager notificationService;
    private final IssueChangePostProcessor issueChangePostProcessor;

    public IssueUpdater(DbClient dbClient, WebIssueStorage issueStorage, NotificationManager notificationService, IssueChangePostProcessor issueChangePostProcessor) {
        this.dbClient = dbClient;
        this.issueStorage = issueStorage;
        this.notificationService = notificationService;
        this.issueChangePostProcessor = issueChangePostProcessor;
    }

    public SearchResponseData saveIssueAndPreloadSearchResponseData(DbSession dbSession, DefaultIssue issue, IssueChangeContext context, @Nullable String comment, boolean refreshMeasures) {
        Optional<RuleDefinitionDto> rule = this.getRuleByKey(dbSession, issue.getRuleKey());
        ComponentDto project = this.dbClient.componentDao().selectOrFailByUuid(dbSession, issue.projectUuid());
        ComponentDto component = this.getComponent(dbSession, issue, issue.componentUuid());
        IssueDto issueDto = this.doSaveIssue(dbSession, issue, context, comment, rule, project, component);
        SearchResponseData result = new SearchResponseData(issueDto);
        rule.ifPresent(r -> result.addRules(Collections.singletonList(r)));
        result.addComponents(Collections.singleton(project));
        result.addComponents(Collections.singleton(component));
        if (refreshMeasures) {
            List changedIssues = (List)result.getIssues().stream().map(IssueDto::toDefaultIssue).collect(MoreCollectors.toList((int)result.getIssues().size()));
            this.issueChangePostProcessor.process(dbSession, changedIssues, Collections.singleton(component));
        }
        return result;
    }

    public IssueDto saveIssue(DbSession session, DefaultIssue issue, IssueChangeContext context, @Nullable String comment) {
        Optional<RuleDefinitionDto> rule = this.getRuleByKey(session, issue.getRuleKey());
        ComponentDto project = this.getComponent(session, issue, issue.projectUuid());
        ComponentDto component = this.getComponent(session, issue, issue.componentUuid());
        return this.doSaveIssue(session, issue, context, comment, rule, project, component);
    }

    private IssueDto doSaveIssue(DbSession session, DefaultIssue issue, IssueChangeContext context, @Nullable String comment, Optional<RuleDefinitionDto> rule, ComponentDto project, ComponentDto component) {
        IssueDto issueDto = this.issueStorage.save(session, Collections.singletonList(issue)).iterator().next();
        if (issue.type() != RuleType.SECURITY_HOTSPOT) {
            String assigneeUuid = issue.assignee();
            UserDto assignee = assigneeUuid == null ? null : this.dbClient.userDao().selectByUuid(session, assigneeUuid);
            String authorUuid = context.userUuid();
            UserDto author = authorUuid == null ? null : this.dbClient.userDao().selectByUuid(session, authorUuid);
            this.notificationService.scheduleForSending((Notification)new IssueChangeNotification().setIssue(issue).setAssignee(assignee).setChangeAuthor(author).setRuleName((String)rule.map(RuleDefinitionDto::getName).orElse(null)).setProject(project).setComponent(component).setComment(comment));
        }
        return issueDto;
    }

    private ComponentDto getComponent(DbSession dbSession, DefaultIssue issue, @Nullable String componentUuid) {
        String issueKey = issue.key();
        Preconditions.checkState((componentUuid != null ? 1 : 0) != 0, (String)"Issue '%s' has no component", (Object[])new Object[]{issueKey});
        ComponentDto component = this.dbClient.componentDao().selectByUuid(dbSession, componentUuid).orElse(null);
        Preconditions.checkState((component != null ? 1 : 0) != 0, (String)"Component uuid '%s' for issue key '%s' cannot be found", (Object[])new Object[]{componentUuid, issueKey});
        return component;
    }

    private Optional<RuleDefinitionDto> getRuleByKey(DbSession session, RuleKey ruleKey) {
        Optional rule = this.dbClient.ruleDao().selectDefinitionByKey(session, ruleKey);
        return rule.isPresent() && ((RuleDefinitionDto)rule.get()).getStatus() != RuleStatus.REMOVED ? rule : Optional.empty();
    }
}

