/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Map;
import org.sonar.api.issue.Issue;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ServerSide;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.issue.Action;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.issue.workflow.Condition;
import org.sonar.server.issue.workflow.IsUnResolved;
import org.sonar.server.user.UserSession;

@ServerSide
public class SetSeverityAction
extends Action {
    public static final String SET_SEVERITY_KEY = "set_severity";
    public static final String SEVERITY_PARAMETER = "severity";
    private final IssueFieldsSetter issueUpdater;
    private final UserSession userSession;

    public SetSeverityAction(IssueFieldsSetter issueUpdater, UserSession userSession) {
        super(SET_SEVERITY_KEY);
        this.issueUpdater = issueUpdater;
        this.userSession = userSession;
        super.setConditions(new Condition[]{new IsUnResolved(), this::isCurrentUserIssueAdminAndNotSecurityHotspot});
    }

    private boolean isCurrentUserIssueAdminAndNotSecurityHotspot(Issue issue) {
        DefaultIssue defaultIssue = (DefaultIssue)issue;
        return defaultIssue.type() != RuleType.SECURITY_HOTSPOT && this.userSession.hasComponentUuidPermission("issueadmin", issue.projectUuid());
    }

    @Override
    public boolean verify(Map<String, Object> properties, Collection<DefaultIssue> issues, UserSession userSession) {
        SetSeverityAction.verifySeverityParameter(properties);
        return true;
    }

    @Override
    public boolean execute(Map<String, Object> properties, Action.Context context) {
        return this.issueUpdater.setManualSeverity(context.issue(), SetSeverityAction.verifySeverityParameter(properties), context.issueChangeContext());
    }

    @Override
    public boolean shouldRefreshMeasures() {
        return true;
    }

    private static String verifySeverityParameter(Map<String, Object> properties) {
        String param = (String)properties.get(SEVERITY_PARAMETER);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)param) ? 1 : 0) != 0, (String)"Missing parameter : '%s'", (Object[])new Object[]{SEVERITY_PARAMETER});
        return param;
    }
}

