/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.Duration;
import org.sonar.api.utils.Durations;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.issue.IssueChangeDto;
import org.sonar.db.issue.IssueDto;
import org.sonar.db.protobuf.DbCommons;
import org.sonar.db.protobuf.DbIssues;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.user.UserDto;
import org.sonar.markdown.Markdown;
import org.sonar.server.es.Facets;
import org.sonar.server.issue.workflow.Transition;
import org.sonar.server.issue.ws.AvatarResolver;
import org.sonar.server.issue.ws.SearchAction;
import org.sonar.server.issue.ws.SearchAdditionalField;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.ws.WsResponseCommonFormat;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Issues;

public class SearchResponseFormat {
    private final Durations durations;
    private final WsResponseCommonFormat commonFormat;
    private final Languages languages;
    private final AvatarResolver avatarFactory;

    public SearchResponseFormat(Durations durations, WsResponseCommonFormat commonFormat, Languages languages, AvatarResolver avatarFactory) {
        this.durations = durations;
        this.commonFormat = commonFormat;
        this.languages = languages;
        this.avatarFactory = avatarFactory;
    }

    Issues.SearchWsResponse formatSearch(Set<SearchAdditionalField> fields, SearchResponseData data, Paging paging, Facets facets) {
        Issues.SearchWsResponse.Builder response = Issues.SearchWsResponse.newBuilder();
        this.formatPaging(paging, response);
        SearchResponseFormat.formatEffortTotal(data, response);
        response.addAllIssues(this.formatIssues(fields, data));
        response.addAllComponents(SearchResponseFormat.formatComponents(data));
        SearchResponseFormat.formatFacets(data, facets, response);
        if (fields.contains((Object)SearchAdditionalField.RULES)) {
            response.setRules(this.formatRules(data));
        }
        if (fields.contains((Object)SearchAdditionalField.USERS)) {
            response.setUsers(this.formatUsers(data));
        }
        if (fields.contains((Object)SearchAdditionalField.LANGUAGES)) {
            response.setLanguages(this.formatLanguages());
        }
        return response.build();
    }

    Issues.Operation formatOperation(SearchResponseData data) {
        Issues.Operation.Builder response = Issues.Operation.newBuilder();
        if (data.getIssues().size() == 1) {
            Issues.Issue.Builder issueBuilder = Issues.Issue.newBuilder();
            IssueDto dto = data.getIssues().get(0);
            this.formatIssue(issueBuilder, dto, data);
            SearchResponseFormat.formatIssueActions(data, issueBuilder, dto);
            SearchResponseFormat.formatIssueTransitions(data, issueBuilder, dto);
            SearchResponseFormat.formatIssueComments(data, issueBuilder, dto);
            response.setIssue(issueBuilder.build());
        }
        response.addAllComponents(SearchResponseFormat.formatComponents(data));
        response.addAllRules((Iterable)this.formatRules(data).getRulesList());
        response.addAllUsers((Iterable)this.formatUsers(data).getUsersList());
        return response.build();
    }

    private static void formatEffortTotal(SearchResponseData data, Issues.SearchWsResponse.Builder response) {
        Long effort = data.getEffortTotal();
        if (effort != null) {
            response.setDebtTotal(effort.longValue());
            response.setEffortTotal(effort.longValue());
        }
    }

    private void formatPaging(Paging paging, Issues.SearchWsResponse.Builder response) {
        response.setP((long)paging.pageIndex());
        response.setPs(paging.pageSize());
        response.setTotal((long)paging.total());
        response.setPaging(this.commonFormat.formatPaging(paging));
    }

    private List<Issues.Issue> formatIssues(Set<SearchAdditionalField> fields, SearchResponseData data) {
        ArrayList<Issues.Issue> result = new ArrayList<Issues.Issue>();
        Issues.Issue.Builder issueBuilder = Issues.Issue.newBuilder();
        data.getIssues().forEach(dto -> {
            issueBuilder.clear();
            this.formatIssue(issueBuilder, (IssueDto)dto, data);
            if (fields.contains((Object)SearchAdditionalField.ACTIONS)) {
                SearchResponseFormat.formatIssueActions(data, issueBuilder, dto);
            }
            if (fields.contains((Object)SearchAdditionalField.TRANSITIONS)) {
                SearchResponseFormat.formatIssueTransitions(data, issueBuilder, dto);
            }
            if (fields.contains((Object)SearchAdditionalField.COMMENTS)) {
                SearchResponseFormat.formatIssueComments(data, issueBuilder, dto);
            }
            result.add(issueBuilder.build());
        });
        return result;
    }

    private void formatIssue(Issues.Issue.Builder issueBuilder, IssueDto dto, SearchResponseData data) {
        issueBuilder.setKey(dto.getKey());
        Optional.ofNullable(dto.getType()).map(Common.RuleType::forNumber).ifPresent(arg_0 -> ((Issues.Issue.Builder)issueBuilder).setType(arg_0));
        ComponentDto component = data.getComponentByUuid(dto.getComponentUuid());
        issueBuilder.setOrganization(data.getOrganizationKey(component.getOrganizationUuid()));
        issueBuilder.setComponent(component.getKey());
        Optional.ofNullable(component.getBranch()).ifPresent(arg_0 -> ((Issues.Issue.Builder)issueBuilder).setBranch(arg_0));
        Optional.ofNullable(component.getPullRequest()).ifPresent(arg_0 -> ((Issues.Issue.Builder)issueBuilder).setPullRequest(arg_0));
        ComponentDto project = data.getComponentByUuid(dto.getProjectUuid());
        if (project != null) {
            issueBuilder.setProject(project.getKey());
            ComponentDto subProject = data.getComponentByUuid(dto.getModuleUuid());
            if (subProject != null && !subProject.getDbKey().equals(project.getDbKey())) {
                issueBuilder.setSubProject(subProject.getKey());
            }
        }
        issueBuilder.setRule(dto.getRuleKey().toString());
        if (dto.isExternal()) {
            issueBuilder.setExternalRuleEngine(SearchResponseFormat.engineNameFrom(dto.getRuleKey()));
        }
        issueBuilder.setFromHotspot(dto.isFromHotspot());
        issueBuilder.setSeverity(Common.Severity.valueOf((String)dto.getSeverity()));
        Optional.ofNullable(data.getUserByUuid(dto.getAssigneeUuid())).ifPresent(assignee -> issueBuilder.setAssignee(assignee.getLogin()));
        Optional.ofNullable(Strings.emptyToNull((String)dto.getResolution())).ifPresent(arg_0 -> ((Issues.Issue.Builder)issueBuilder).setResolution(arg_0));
        issueBuilder.setStatus(dto.getStatus());
        issueBuilder.setMessage(Strings.nullToEmpty((String)dto.getMessage()));
        issueBuilder.addAllTags((Iterable)dto.getTags());
        Long effort = dto.getEffort();
        if (effort != null) {
            String effortValue = this.durations.encode(Duration.create((long)effort));
            issueBuilder.setDebt(effortValue);
            issueBuilder.setEffort(effortValue);
        }
        Optional.ofNullable(dto.getLine()).ifPresent(arg_0 -> ((Issues.Issue.Builder)issueBuilder).setLine(arg_0));
        Optional.ofNullable(Strings.emptyToNull((String)dto.getChecksum())).ifPresent(arg_0 -> ((Issues.Issue.Builder)issueBuilder).setHash(arg_0));
        SearchResponseFormat.completeIssueLocations(dto, issueBuilder, data);
        if (data.getUserOrganizationUuids().contains(component.getOrganizationUuid())) {
            issueBuilder.setAuthor(Strings.nullToEmpty((String)dto.getAuthorLogin()));
        }
        Optional.ofNullable(dto.getIssueCreationDate()).map(DateUtils::formatDateTime).ifPresent(arg_0 -> ((Issues.Issue.Builder)issueBuilder).setCreationDate(arg_0));
        Optional.ofNullable(dto.getIssueUpdateDate()).map(DateUtils::formatDateTime).ifPresent(arg_0 -> ((Issues.Issue.Builder)issueBuilder).setUpdateDate(arg_0));
        Optional.ofNullable(dto.getIssueCloseDate()).map(DateUtils::formatDateTime).ifPresent(arg_0 -> ((Issues.Issue.Builder)issueBuilder).setCloseDate(arg_0));
    }

    private static String engineNameFrom(RuleKey ruleKey) {
        Preconditions.checkState((boolean)ruleKey.repository().startsWith("external_"));
        return ruleKey.repository().replace("external_", "");
    }

    private static void completeIssueLocations(IssueDto dto, Issues.Issue.Builder issueBuilder, SearchResponseData data) {
        DbIssues.Locations locations = dto.parseLocations();
        if (locations == null) {
            return;
        }
        if (locations.hasTextRange()) {
            DbCommons.TextRange textRange = locations.getTextRange();
            issueBuilder.setTextRange(SearchResponseFormat.convertTextRange(textRange));
        }
        for (DbIssues.Flow flow : locations.getFlowList()) {
            Issues.Flow.Builder targetFlow = Issues.Flow.newBuilder();
            for (DbIssues.Location flowLocation : flow.getLocationList()) {
                targetFlow.addLocations(SearchResponseFormat.convertLocation(issueBuilder, flowLocation, data));
            }
            issueBuilder.addFlows(targetFlow);
        }
    }

    private static Issues.Location convertLocation(Issues.Issue.Builder issueBuilder, DbIssues.Location source, SearchResponseData data) {
        Issues.Location.Builder target = Issues.Location.newBuilder();
        if (source.hasMsg()) {
            target.setMsg(source.getMsg());
        }
        if (source.hasTextRange()) {
            DbCommons.TextRange sourceRange = source.getTextRange();
            Common.TextRange.Builder targetRange = SearchResponseFormat.convertTextRange(sourceRange);
            target.setTextRange(targetRange);
        }
        if (source.hasComponentId()) {
            Optional.ofNullable(data.getComponentByUuid(source.getComponentId())).ifPresent(c -> target.setComponent(c.getKey()));
        } else {
            target.setComponent(issueBuilder.getComponent());
        }
        return target.build();
    }

    private static Common.TextRange.Builder convertTextRange(DbCommons.TextRange sourceRange) {
        Common.TextRange.Builder targetRange = Common.TextRange.newBuilder();
        if (sourceRange.hasStartLine()) {
            targetRange.setStartLine(sourceRange.getStartLine());
        }
        if (sourceRange.hasStartOffset()) {
            targetRange.setStartOffset(sourceRange.getStartOffset());
        }
        if (sourceRange.hasEndLine()) {
            targetRange.setEndLine(sourceRange.getEndLine());
        }
        if (sourceRange.hasEndOffset()) {
            targetRange.setEndOffset(sourceRange.getEndOffset());
        }
        return targetRange;
    }

    private static void formatIssueTransitions(SearchResponseData data, Issues.Issue.Builder wsIssue, IssueDto dto) {
        Issues.Transitions.Builder wsTransitions = Issues.Transitions.newBuilder();
        List<Transition> transitions = data.getTransitionsForIssueKey(dto.getKey());
        if (transitions != null) {
            for (Transition transition : transitions) {
                wsTransitions.addTransitions(transition.key());
            }
        }
        wsIssue.setTransitions(wsTransitions);
    }

    private static void formatIssueActions(SearchResponseData data, Issues.Issue.Builder wsIssue, IssueDto dto) {
        Issues.Actions.Builder wsActions = Issues.Actions.newBuilder();
        List<String> actions = data.getActionsForIssueKey(dto.getKey());
        if (actions != null) {
            wsActions.addAllActions(actions);
        }
        wsIssue.setActions(wsActions);
    }

    private static void formatIssueComments(SearchResponseData data, Issues.Issue.Builder wsIssue, IssueDto dto) {
        Issues.Comments.Builder wsComments = Issues.Comments.newBuilder();
        List<IssueChangeDto> comments = data.getCommentsForIssueKey(dto.getKey());
        if (comments != null) {
            Issues.Comment.Builder wsComment = Issues.Comment.newBuilder();
            for (IssueChangeDto comment : comments) {
                String markdown = comment.getChangeData();
                wsComment.clear().setKey(comment.getKey()).setUpdatable(data.isUpdatableComment(comment.getKey())).setCreatedAt(DateUtils.formatDateTime((Date)new Date(comment.getIssueChangeCreationDate())));
                Optional.ofNullable(data.getUserByUuid(comment.getUserUuid())).ifPresent(user -> wsComment.setLogin(user.getLogin()));
                if (markdown != null) {
                    wsComment.setHtmlText(Markdown.convertToHtml((String)markdown)).setMarkdown(markdown);
                }
                wsComments.addComments(wsComment);
            }
        }
        wsIssue.setComments(wsComments);
    }

    private Common.Rules.Builder formatRules(SearchResponseData data) {
        Common.Rules.Builder wsRules = Common.Rules.newBuilder();
        List rules = (List)MoreObjects.firstNonNull(data.getRules(), Collections.emptyList());
        for (RuleDefinitionDto rule : rules) {
            wsRules.addRules(this.commonFormat.formatRule(rule));
        }
        return wsRules;
    }

    private static List<Issues.Component> formatComponents(SearchResponseData data) {
        Collection<ComponentDto> components = data.getComponents();
        ArrayList<Issues.Component> result = new ArrayList<Issues.Component>();
        for (ComponentDto dto : components) {
            String uuid = dto.uuid();
            Issues.Component.Builder builder = Issues.Component.newBuilder().setOrganization(data.getOrganizationKey(dto.getOrganizationUuid())).setKey(dto.getKey()).setUuid(uuid).setQualifier(dto.qualifier()).setName(Strings.nullToEmpty((String)dto.name())).setLongName(Strings.nullToEmpty((String)dto.longName())).setEnabled(dto.isEnabled());
            Optional.ofNullable(dto.getBranch()).ifPresent(arg_0 -> ((Issues.Component.Builder)builder).setBranch(arg_0));
            Optional.ofNullable(dto.getPullRequest()).ifPresent(arg_0 -> ((Issues.Component.Builder)builder).setPullRequest(arg_0));
            Optional.ofNullable(Strings.emptyToNull((String)dto.path())).ifPresent(arg_0 -> ((Issues.Component.Builder)builder).setPath(arg_0));
            result.add(builder.build());
        }
        return result;
    }

    private Issues.Users.Builder formatUsers(SearchResponseData data) {
        Issues.Users.Builder wsUsers = Issues.Users.newBuilder();
        List<UserDto> users = data.getUsers();
        if (users != null) {
            for (UserDto user : users) {
                wsUsers.addUsers(this.formatUser(user));
            }
        }
        return wsUsers;
    }

    private Issues.Users.User.Builder formatUser(UserDto user) {
        Issues.Users.User.Builder builder = Issues.Users.User.newBuilder().setLogin(user.getLogin()).setName(Strings.nullToEmpty((String)user.getName())).setActive(user.isActive());
        Optional.ofNullable(Strings.emptyToNull((String)user.getEmail())).ifPresent(email -> builder.setAvatar(this.avatarFactory.create(user)));
        return builder;
    }

    private Issues.Languages.Builder formatLanguages() {
        Issues.Languages.Builder wsLangs = Issues.Languages.newBuilder();
        Issues.Language.Builder wsLang = Issues.Language.newBuilder();
        for (Language lang : this.languages.all()) {
            wsLang.clear().setKey(lang.getKey()).setName(lang.getName());
            wsLangs.addLanguages(wsLang);
        }
        return wsLangs;
    }

    private static void formatFacets(SearchResponseData data, Facets facets, Issues.SearchWsResponse.Builder wsSearch) {
        Common.Facets.Builder wsFacets = Common.Facets.newBuilder();
        SearchAction.SUPPORTED_FACETS.stream().filter(f -> !f.equals("projects")).filter(f -> !f.equals("assigned_to_me")).filter(f -> !f.equals("assignees")).filter(f -> !f.equals("rules")).forEach(f -> SearchResponseFormat.computeStandardFacet(wsFacets, facets, f));
        SearchResponseFormat.computeAssigneesFacet(wsFacets, facets, data);
        SearchResponseFormat.computeAssignedToMeFacet(wsFacets, facets, data);
        SearchResponseFormat.computeRulesFacet(wsFacets, facets, data);
        SearchResponseFormat.computeProjectsFacet(wsFacets, facets, data);
        wsSearch.setFacets(wsFacets.build());
    }

    private static void computeStandardFacet(Common.Facets.Builder wsFacets, Facets facets, String facetKey) {
        LinkedHashMap facet = facets.get(facetKey);
        if (facet == null) {
            return;
        }
        Common.Facet.Builder wsFacet = wsFacets.addFacetsBuilder();
        wsFacet.setProperty(facetKey);
        facet.forEach((value, count) -> wsFacet.addValuesBuilder().setVal(value).setCount(count.longValue()).build());
        wsFacet.build();
    }

    private static void computeAssigneesFacet(Common.Facets.Builder wsFacets, Facets facets, SearchResponseData data) {
        LinkedHashMap facet = facets.get("assignees");
        if (facet == null) {
            return;
        }
        Common.Facet.Builder wsFacet = wsFacets.addFacetsBuilder();
        wsFacet.setProperty("assignees");
        facet.forEach((userUuid, count) -> {
            UserDto user = data.getUserByUuid((String)userUuid);
            wsFacet.addValuesBuilder().setVal(user == null ? "" : user.getLogin()).setCount(count.longValue()).build();
        });
        wsFacet.build();
    }

    private static void computeAssignedToMeFacet(Common.Facets.Builder wsFacets, Facets facets, SearchResponseData data) {
        LinkedHashMap facet = facets.get("assigned_to_me");
        if (facet == null) {
            return;
        }
        Map.Entry entry = facet.entrySet().iterator().next();
        UserDto user = data.getUserByUuid((String)entry.getKey());
        Preconditions.checkState((user != null ? 1 : 0) != 0, (String)"User with uuid '%s' has not been found", (Object[])new Object[]{entry.getKey()});
        Common.Facet.Builder wsFacet = wsFacets.addFacetsBuilder();
        wsFacet.setProperty("assigned_to_me");
        wsFacet.addValuesBuilder().setVal(user.getLogin()).setCount(((Long)entry.getValue()).longValue()).build();
    }

    private static void computeRulesFacet(Common.Facets.Builder wsFacets, Facets facets, SearchResponseData data) {
        LinkedHashMap facet = facets.get("rules");
        if (facet == null) {
            return;
        }
        Map ruleIdsByRuleKeys = (Map)data.getRules().stream().collect(MoreCollectors.uniqueIndex(RuleDefinitionDto::getId, RuleDefinitionDto::getKey));
        Common.Facet.Builder wsFacet = wsFacets.addFacetsBuilder();
        wsFacet.setProperty("rules");
        facet.forEach((ruleId, count) -> wsFacet.addValuesBuilder().setVal(((RuleKey)ruleIdsByRuleKeys.get(Integer.parseInt(ruleId))).toString()).setCount(count.longValue()).build());
        wsFacet.build();
    }

    private static void computeProjectsFacet(Common.Facets.Builder wsFacets, Facets facets, SearchResponseData datas) {
        LinkedHashMap facet = facets.get("projects");
        if (facet == null) {
            return;
        }
        Common.Facet.Builder wsFacet = wsFacets.addFacetsBuilder();
        wsFacet.setProperty("projects");
        facet.forEach((uuid, count) -> {
            ComponentDto component = datas.getComponentByUuid((String)uuid);
            Objects.requireNonNull(component, String.format("Component has not been found for uuid '%s'", uuid));
            wsFacet.addValuesBuilder().setVal(component.getKey()).setCount(count.longValue()).build();
        });
        wsFacet.build();
    }
}

