/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.MoreObjects;
import com.google.common.io.Resources;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.issue.IssueDto;
import org.sonar.server.issue.IssueFieldsSetter;
import org.sonar.server.issue.IssueFinder;
import org.sonar.server.issue.IssueUpdater;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.issue.ws.OperationResponseWriter;
import org.sonar.server.issue.ws.SearchResponseData;
import org.sonar.server.user.UserSession;

public class SetTagsAction
implements IssuesWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final IssueFinder issueFinder;
    private final IssueFieldsSetter issueFieldsSetter;
    private final IssueUpdater issueUpdater;
    private final OperationResponseWriter responseWriter;

    public SetTagsAction(UserSession userSession, DbClient dbClient, IssueFinder issueFinder, IssueFieldsSetter issueFieldsSetter, IssueUpdater issueUpdater, OperationResponseWriter responseWriter) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.issueFinder = issueFinder;
        this.issueFieldsSetter = issueFieldsSetter;
        this.issueUpdater = issueUpdater;
        this.responseWriter = responseWriter;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("set_tags").setPost(true).setSince("5.1").setDescription("Set tags on an issue. <br/>Requires authentication and Browse permission on project").setChangelog(new Change[]{new Change("6.5", "the database ids of the components are removed from the response"), new Change("6.5", "the response field components.uuid is deprecated. Use components.key instead."), new Change("6.4", "response contains issue information instead of list of tags")}).setResponseExample(Resources.getResource(this.getClass(), (String)"set_tags-example.json")).setHandler((RequestHandler)this);
        action.createParam("issue").setDescription("Issue key").setSince("6.3").setDeprecatedKey("key", "6.3").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy").setRequired(true);
        action.createParam("tags").setDescription("Comma-separated list of tags. All tags are removed if parameter is empty or not set.").setExampleValue((Object)"security,cwe,misra-c");
    }

    public void handle(Request request, Response response) throws Exception {
        String key = request.mandatoryParam("issue");
        List tags = (List)MoreObjects.firstNonNull((Object)request.paramAsStrings("tags"), Collections.emptyList());
        SearchResponseData preloadedSearchResponseData = this.setTags(key, tags);
        this.responseWriter.write(key, preloadedSearchResponseData, request, response);
    }

    private SearchResponseData setTags(String issueKey, List<String> tags) {
        this.userSession.checkLoggedIn();
        try (DbSession session = this.dbClient.openSession(false);){
            IssueDto issueDto = this.issueFinder.getByKey(session, issueKey);
            DefaultIssue issue = issueDto.toDefaultIssue();
            IssueChangeContext context = IssueChangeContext.createUser((Date)new Date(), (String)this.userSession.getUuid());
            if (this.issueFieldsSetter.setTags(issue, tags, context)) {
                SearchResponseData searchResponseData = this.issueUpdater.saveIssueAndPreloadSearchResponseData(session, issue, context, null, false);
                return searchResponseData;
            }
            SearchResponseData searchResponseData = new SearchResponseData(issueDto);
            return searchResponseData;
        }
    }
}

