/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.live;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.rules.RuleType;
import org.sonar.db.issue.IssueGroupDto;
import org.sonar.db.rule.SeverityUtil;

class IssueCounter {
    private final Map<RuleType, HighestSeverity> highestSeverityOfUnresolved = new EnumMap<RuleType, HighestSeverity>(RuleType.class);
    private final Map<RuleType, Effort> effortOfUnresolved = new EnumMap<RuleType, Effort>(RuleType.class);
    private final Map<String, Count> unresolvedBySeverity = new HashMap<String, Count>();
    private final Map<RuleType, Count> unresolvedByType = new EnumMap<RuleType, Count>(RuleType.class);
    private final Map<String, Count> byResolution = new HashMap<String, Count>();
    private final Map<String, Count> byStatus = new HashMap<String, Count>();
    private final Count unresolved = new Count();

    IssueCounter(Collection<IssueGroupDto> groups) {
        for (IssueGroupDto group : groups) {
            RuleType ruleType = RuleType.valueOf((int)group.getRuleType());
            if (group.getResolution() == null) {
                this.highestSeverityOfUnresolved.computeIfAbsent(ruleType, k -> new HighestSeverity()).add(group);
                this.effortOfUnresolved.computeIfAbsent(ruleType, k -> new Effort()).add(group);
                this.unresolvedBySeverity.computeIfAbsent(group.getSeverity(), k -> new Count()).add(group);
                this.unresolvedByType.computeIfAbsent(ruleType, k -> new Count()).add(group);
                this.unresolved.add(group);
            } else {
                this.byResolution.computeIfAbsent(group.getResolution(), k -> new Count()).add(group);
            }
            if (group.getStatus() == null) continue;
            this.byStatus.computeIfAbsent(group.getStatus(), k -> new Count()).add(group);
        }
    }

    public Optional<String> getHighestSeverityOfUnresolved(RuleType ruleType, boolean onlyInLeak) {
        return Optional.ofNullable(this.highestSeverityOfUnresolved.get(ruleType)).map(hs -> hs.severity(onlyInLeak));
    }

    public double sumEffortOfUnresolved(RuleType type, boolean onlyInLeak) {
        Effort effort = this.effortOfUnresolved.get(type);
        if (effort == null) {
            return 0.0;
        }
        return onlyInLeak ? effort.leak : effort.absolute;
    }

    public long countUnresolvedBySeverity(String severity, boolean onlyInLeak) {
        return IssueCounter.value(this.unresolvedBySeverity.get(severity), onlyInLeak);
    }

    public long countByResolution(String resolution, boolean onlyInLeak) {
        return IssueCounter.value(this.byResolution.get(resolution), onlyInLeak);
    }

    public long countUnresolvedByType(RuleType type, boolean onlyInLeak) {
        return IssueCounter.value(this.unresolvedByType.get(type), onlyInLeak);
    }

    public long countByStatus(String status, boolean onlyInLeak) {
        return IssueCounter.value(this.byStatus.get(status), onlyInLeak);
    }

    public long countUnresolved(boolean onlyInLeak) {
        return IssueCounter.value(this.unresolved, onlyInLeak);
    }

    private static long value(@Nullable Count count, boolean onlyInLeak) {
        if (count == null) {
            return 0L;
        }
        return onlyInLeak ? count.leak : count.absolute;
    }

    private static class HighestSeverity {
        private int absolute = SeverityUtil.getOrdinalFromSeverity((String)"INFO");
        private int leak = SeverityUtil.getOrdinalFromSeverity((String)"INFO");

        private HighestSeverity() {
        }

        void add(IssueGroupDto group) {
            int severity = SeverityUtil.getOrdinalFromSeverity((String)group.getSeverity());
            this.absolute = Math.max(severity, this.absolute);
            if (group.isInLeak()) {
                this.leak = Math.max(severity, this.leak);
            }
        }

        String severity(boolean inLeak) {
            return SeverityUtil.getSeverityFromOrdinal((int)(inLeak ? this.leak : this.absolute));
        }
    }

    private static class Effort {
        private double absolute = 0.0;
        private double leak = 0.0;

        private Effort() {
        }

        void add(IssueGroupDto group) {
            this.absolute += group.getEffort();
            if (group.isInLeak()) {
                this.leak += group.getEffort();
            }
        }
    }

    private static class Count {
        private long absolute = 0L;
        private long leak = 0L;

        private Count() {
        }

        void add(IssueGroupDto group) {
            if (group.getRuleType() != RuleType.SECURITY_HOTSPOT.getDbConstant()) {
                this.absolute += group.getCount();
                if (group.isInLeak()) {
                    this.leak += group.getCount();
                }
            }
        }
    }
}

