/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import java.util.Map;
import java.util.Optional;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.measure.ws.MeasureDtoToWsMeasure;
import org.sonarqube.ws.Measures;

class ComponentDtoToWsComponent {
    private ComponentDtoToWsComponent() {
    }

    static Measures.Component.Builder componentDtoToWsComponent(ComponentDto component, Map<MetricDto, LiveMeasureDto> measuresByMetric, Map<String, ComponentDto> referenceComponentsByUuid) {
        Measures.Component.Builder wsComponent = ComponentDtoToWsComponent.componentDtoToWsComponent(component);
        ComponentDto referenceComponent = referenceComponentsByUuid.get(component.getCopyResourceUuid());
        if (referenceComponent != null) {
            wsComponent.setRefId(referenceComponent.uuid());
            wsComponent.setRefKey(referenceComponent.getDbKey());
        }
        Measures.Measure.Builder measureBuilder = Measures.Measure.newBuilder();
        for (Map.Entry<MetricDto, LiveMeasureDto> entry : measuresByMetric.entrySet()) {
            MeasureDtoToWsMeasure.updateMeasureBuilder(measureBuilder, entry.getKey(), entry.getValue());
            wsComponent.addMeasures(measureBuilder);
            measureBuilder.clear();
        }
        return wsComponent;
    }

    static Measures.Component.Builder componentDtoToWsComponent(ComponentDto component) {
        Measures.Component.Builder wsComponent = Measures.Component.newBuilder().setId(component.uuid()).setKey(component.getKey()).setName(component.name()).setQualifier(component.qualifier());
        Optional.ofNullable(component.getBranch()).ifPresent(arg_0 -> ((Measures.Component.Builder)wsComponent).setBranch(arg_0));
        Optional.ofNullable(component.getPullRequest()).ifPresent(arg_0 -> ((Measures.Component.Builder)wsComponent).setPullRequest(arg_0));
        Optional.ofNullable(component.path()).ifPresent(arg_0 -> ((Measures.Component.Builder)wsComponent).setPath(arg_0));
        Optional.ofNullable(component.description()).ifPresent(arg_0 -> ((Measures.Component.Builder)wsComponent).setDescription(arg_0));
        Optional.ofNullable(component.language()).ifPresent(arg_0 -> ((Measures.Component.Builder)wsComponent).setLanguage(arg_0));
        return wsComponent;
    }
}

