/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification.ws;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.property.PropertyDto;
import org.sonar.db.property.PropertyQuery;
import org.sonar.db.user.UserDto;
import org.sonar.server.notification.NotificationCenter;
import org.sonar.server.notification.ws.Dispatchers;
import org.sonar.server.notification.ws.NotificationsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Notifications;

public class ListAction
implements NotificationsWsAction {
    private static final Splitter PROPERTY_KEY_SPLITTER = Splitter.on((String)".");
    private final DbClient dbClient;
    private final UserSession userSession;
    private final List<String> channels;
    private final Dispatchers dispatchers;

    public ListAction(NotificationCenter notificationCenter, DbClient dbClient, UserSession userSession, Dispatchers dispatchers) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.channels = (List)notificationCenter.getChannels().stream().map(NotificationChannel::getKey).sorted().collect(MoreCollectors.toList());
        this.dispatchers = dispatchers;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("list").setDescription("List notifications of the authenticated user.<br>Requires one of the following permissions:<ul>  <li>Authentication if no login is provided</li>  <li>System administration if a login is provided</li></ul>").setSince("6.3").setResponseExample(this.getClass().getResource("list-example.json")).setHandler((RequestHandler)this);
        action.createParam("login").setDescription("User login").setSince("6.4");
    }

    public void handle(Request request, Response response) throws Exception {
        Notifications.ListResponse listResponse = this.search(request);
        WsUtils.writeProtobuf((Message)listResponse, request, response);
    }

    private Notifications.ListResponse search(Request request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.checkPermissions(request);
            UserDto user = this.getUser(dbSession, request);
            Notifications.ListResponse listResponse = (Notifications.ListResponse)Stream.of(Notifications.ListResponse.newBuilder()).map(r -> r.addAllChannels(this.channels)).map(r -> r.addAllGlobalTypes(this.dispatchers.getGlobalDispatchers())).map(r -> r.addAllPerProjectTypes(this.dispatchers.getProjectDispatchers())).map(this.addNotifications(dbSession, user)).map(Notifications.ListResponse.Builder::build).collect(MoreCollectors.toOneElement());
            return listResponse;
        }
    }

    private UserDto getUser(DbSession dbSession, Request request) {
        String login = request.param("login") == null ? this.userSession.getLogin() : request.param("login");
        return WsUtils.checkFound(this.dbClient.userDao().selectByLogin(dbSession, login), "User '%s' not found", login);
    }

    private UnaryOperator<Notifications.ListResponse.Builder> addNotifications(DbSession dbSession, UserDto user) {
        return response -> {
            List properties = this.dbClient.propertiesDao().selectByQuery(PropertyQuery.builder().setUserId(user.getId()).build(), dbSession);
            Map<Long, ComponentDto> componentsById = this.searchProjects(dbSession, properties);
            Map<String, OrganizationDto> organizationsByUuid = this.getOrganizations(dbSession, componentsById.values());
            Predicate<PropertyDto> isNotification = prop -> prop.getKey().startsWith("notification.");
            Predicate<PropertyDto> isComponentInDb = prop -> prop.getResourceId() == null || componentsById.containsKey(prop.getResourceId());
            Notifications.Notification.Builder notification = Notifications.Notification.newBuilder();
            properties.stream().filter(isNotification).filter(this.channelAndDispatcherAuthorized()).filter(isComponentInDb).map(ListAction.toWsNotification(notification, organizationsByUuid, componentsById)).sorted(Comparator.comparing(Notifications.Notification::getProject, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Comparator.comparing(Notifications.Notification::getChannel)).thenComparing(Comparator.comparing(Notifications.Notification::getType))).forEach(arg_0 -> ((Notifications.ListResponse.Builder)response).addNotifications(arg_0));
            return response;
        };
    }

    private Predicate<PropertyDto> channelAndDispatcherAuthorized() {
        return prop -> {
            List key = PROPERTY_KEY_SPLITTER.splitToList((CharSequence)prop.getKey());
            return key.size() == 3 && this.channels.contains(key.get(2)) && this.isDispatcherAuthorized((PropertyDto)prop, (String)key.get(1));
        };
    }

    private boolean isDispatcherAuthorized(PropertyDto prop, String dispatcher) {
        return prop.getResourceId() != null && this.dispatchers.getProjectDispatchers().contains(dispatcher) || this.dispatchers.getGlobalDispatchers().contains(dispatcher);
    }

    private Map<Long, ComponentDto> searchProjects(DbSession dbSession, List<PropertyDto> properties) {
        Set componentIds = (Set)properties.stream().map(PropertyDto::getResourceId).filter(Objects::nonNull).collect(MoreCollectors.toSet((int)properties.size()));
        Set authorizedProjectIds = this.dbClient.authorizationDao().keepAuthorizedProjectIds(dbSession, (Collection)componentIds, this.userSession.getUserId(), "user");
        return (Map)this.dbClient.componentDao().selectByIds(dbSession, (Collection)componentIds).stream().filter(c -> authorizedProjectIds.contains(c.getId())).collect(MoreCollectors.uniqueIndex(ComponentDto::getId));
    }

    private Map<String, OrganizationDto> getOrganizations(DbSession dbSession, Collection<ComponentDto> values) {
        Set organizationUuids = (Set)values.stream().map(ComponentDto::getOrganizationUuid).collect(MoreCollectors.toSet());
        return (Map)this.dbClient.organizationDao().selectByUuids(dbSession, organizationUuids).stream().collect(MoreCollectors.uniqueIndex(OrganizationDto::getUuid));
    }

    private static Function<PropertyDto, Notifications.Notification> toWsNotification(Notifications.Notification.Builder notification, Map<String, OrganizationDto> organizationsByUuid, Map<Long, ComponentDto> projectsById) {
        return property -> {
            notification.clear();
            List propertyKey = Splitter.on((String)".").splitToList((CharSequence)property.getKey());
            notification.setType((String)propertyKey.get(1));
            notification.setChannel((String)propertyKey.get(2));
            Optional.ofNullable(property.getResourceId()).ifPresent(componentId -> ListAction.populateProjectFields(notification, componentId, organizationsByUuid, projectsById));
            return notification.build();
        };
    }

    private static Notifications.Notification.Builder populateProjectFields(Notifications.Notification.Builder notification, Long componentId, Map<String, OrganizationDto> organizationsByUuid, Map<Long, ComponentDto> projectsById) {
        ComponentDto project = projectsById.get(componentId);
        String organizationUuid = project.getOrganizationUuid();
        OrganizationDto organizationDto = organizationsByUuid.get(organizationUuid);
        Preconditions.checkArgument((organizationDto != null ? 1 : 0) != 0, (String)"No organization for uuid '%s'", (Object[])new Object[]{organizationUuid});
        return notification.setOrganization(organizationDto.getKey()).setProject(project.getDbKey()).setProjectName(project.name());
    }

    private void checkPermissions(Request request) {
        if (request.param("login") == null) {
            this.userSession.checkLoggedIn();
        } else {
            this.userSession.checkIsSystemAdministrator();
        }
    }
}

