/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.DefaultTemplates;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.organization.OrganizationMemberDto;
import org.sonar.db.permission.GroupPermissionDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.permission.UserPermissionDto;
import org.sonar.db.permission.template.PermissionTemplateCharacteristicDto;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.db.qualityprofile.DefaultQProfileDto;
import org.sonar.db.qualityprofile.OrgQProfileDto;
import org.sonar.db.user.GroupDto;
import org.sonar.db.user.UserDto;
import org.sonar.db.user.UserGroupDto;
import org.sonar.server.organization.OrganizationUpdater;
import org.sonar.server.organization.OrganizationValidation;
import org.sonar.server.permission.PermissionService;
import org.sonar.server.qualityprofile.BuiltInQProfile;
import org.sonar.server.qualityprofile.BuiltInQProfileRepository;
import org.sonar.server.qualityprofile.QProfileName;
import org.sonar.server.user.index.UserIndexer;
import org.sonar.server.usergroups.DefaultGroupCreator;

public class OrganizationUpdaterImpl
implements OrganizationUpdater {
    private final DbClient dbClient;
    private final System2 system2;
    private final UuidFactory uuidFactory;
    private final OrganizationValidation organizationValidation;
    private final Configuration config;
    private final BuiltInQProfileRepository builtInQProfileRepository;
    private final DefaultGroupCreator defaultGroupCreator;
    private final UserIndexer userIndexer;
    private final PermissionService permissionService;

    public OrganizationUpdaterImpl(DbClient dbClient, System2 system2, UuidFactory uuidFactory, OrganizationValidation organizationValidation, Configuration config, UserIndexer userIndexer, BuiltInQProfileRepository builtInQProfileRepository, DefaultGroupCreator defaultGroupCreator, PermissionService permissionService) {
        this.dbClient = dbClient;
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
        this.organizationValidation = organizationValidation;
        this.config = config;
        this.userIndexer = userIndexer;
        this.builtInQProfileRepository = builtInQProfileRepository;
        this.defaultGroupCreator = defaultGroupCreator;
        this.permissionService = permissionService;
    }

    @Override
    public OrganizationDto create(DbSession dbSession, UserDto userCreator, OrganizationUpdater.NewOrganization newOrganization, Consumer<OrganizationDto> beforeCommit) throws OrganizationUpdater.KeyConflictException {
        this.validate(newOrganization);
        String key = newOrganization.getKey();
        if (this.organizationKeyIsUsed(dbSession, key)) {
            throw new OrganizationUpdater.KeyConflictException(String.format("Organization key '%s' is already used", key));
        }
        QualityGateDto builtInQualityGate = this.dbClient.qualityGateDao().selectBuiltIn(dbSession);
        OrganizationDto organization = this.insertOrganization(dbSession, newOrganization, builtInQualityGate, new Consumer[0]);
        beforeCommit.accept(organization);
        this.insertOrganizationMember(dbSession, organization, userCreator.getId());
        this.dbClient.qualityGateDao().associate(dbSession, this.uuidFactory.create(), organization, builtInQualityGate);
        GroupDto ownerGroup = this.insertOwnersGroup(dbSession, organization);
        GroupDto defaultGroup = this.defaultGroupCreator.create(dbSession, organization.getUuid());
        this.insertDefaultTemplateOnGroups(dbSession, organization, ownerGroup, defaultGroup);
        this.addCurrentUserToGroup(dbSession, ownerGroup, userCreator.getId());
        this.addCurrentUserToGroup(dbSession, defaultGroup, userCreator.getId());
        try (DbSession batchDbSession = this.dbClient.openSession(true);){
            this.insertQualityProfiles(dbSession, batchDbSession, organization);
            batchDbSession.commit();
            this.userIndexer.commitAndIndex(dbSession, userCreator);
            OrganizationDto organizationDto = organization;
            return organizationDto;
        }
    }

    @Override
    public Optional<OrganizationDto> createForUser(DbSession dbSession, UserDto newUser) {
        if (!this.isCreatePersonalOrgEnabled()) {
            return Optional.empty();
        }
        String nameOrLogin = OrganizationUpdaterImpl.nameOrLogin(newUser);
        OrganizationUpdater.NewOrganization newOrganization = OrganizationUpdater.NewOrganization.newOrganizationBuilder().setKey(this.organizationValidation.generateKeyFrom(newUser.getLogin())).setName(this.toName(nameOrLogin)).setDescription(String.format("%s's personal organization", nameOrLogin)).build();
        this.checkKey(dbSession, newOrganization.getKey());
        QualityGateDto builtInQualityGate = this.dbClient.qualityGateDao().selectBuiltIn(dbSession);
        OrganizationDto organization = this.insertOrganization(dbSession, newOrganization, builtInQualityGate, dto -> dto.setGuarded(true));
        this.dbClient.userDao().update(dbSession, newUser.setOrganizationUuid(organization.getUuid()));
        this.insertOrganizationMember(dbSession, organization, newUser.getId());
        GroupDto defaultGroup = this.defaultGroupCreator.create(dbSession, organization.getUuid());
        this.dbClient.qualityGateDao().associate(dbSession, this.uuidFactory.create(), organization, builtInQualityGate);
        this.permissionService.getAllOrganizationPermissions().forEach(p -> this.insertUserPermissions(dbSession, newUser, organization, (OrganizationPermission)p));
        this.insertPersonalOrgDefaultTemplate(dbSession, organization, defaultGroup);
        try (DbSession batchDbSession = this.dbClient.openSession(true);){
            this.insertQualityProfiles(dbSession, batchDbSession, organization);
            this.addCurrentUserToGroup(dbSession, defaultGroup, newUser.getId());
            batchDbSession.commit();
            this.userIndexer.commitAndIndex(dbSession, newUser);
            Optional<OrganizationDto> optional = Optional.of(organization);
            return optional;
        }
    }

    @Override
    public void updateOrganizationKey(DbSession dbSession, OrganizationDto organization, String newKey) {
        String sanitizedKey = this.organizationValidation.generateKeyFrom(newKey);
        if (organization.getKey().equals(sanitizedKey)) {
            return;
        }
        this.checkKey(dbSession, sanitizedKey);
        this.dbClient.organizationDao().update(dbSession, organization.setKey(sanitizedKey));
    }

    private void checkKey(DbSession dbSession, String key) {
        Preconditions.checkState((!this.organizationKeyIsUsed(dbSession, key) ? 1 : 0) != 0, (String)"Can't create organization with key '%s' because an organization with this key already exists", (Object[])new Object[]{key});
    }

    private static String nameOrLogin(UserDto newUser) {
        String name = newUser.getName();
        if (name == null || name.isEmpty()) {
            return newUser.getLogin();
        }
        return name;
    }

    private String toName(String login) {
        String name = login.substring(0, Math.min(login.length(), 255));
        this.organizationValidation.checkName(name);
        return name;
    }

    private boolean isCreatePersonalOrgEnabled() {
        return this.config.getBoolean("sonar.organizations.createPersonalOrg").orElse(false);
    }

    private void validate(OrganizationUpdater.NewOrganization newOrganization) {
        Objects.requireNonNull(newOrganization, "newOrganization can't be null");
        this.organizationValidation.checkName(newOrganization.getName());
        this.organizationValidation.checkKey(newOrganization.getKey());
        this.organizationValidation.checkDescription(newOrganization.getDescription());
        this.organizationValidation.checkUrl(newOrganization.getUrl());
        this.organizationValidation.checkAvatar(newOrganization.getAvatar());
    }

    private OrganizationDto insertOrganization(DbSession dbSession, OrganizationUpdater.NewOrganization newOrganization, QualityGateDto builtInQualityGate, Consumer<OrganizationDto> ... extendCreation) {
        OrganizationDto res = new OrganizationDto().setUuid(this.uuidFactory.create()).setName(newOrganization.getName()).setKey(newOrganization.getKey()).setDescription(newOrganization.getDescription()).setUrl(newOrganization.getUrl()).setDefaultQualityGateUuid(builtInQualityGate.getUuid()).setAvatarUrl(newOrganization.getAvatar()).setSubscription(OrganizationDto.Subscription.FREE);
        Arrays.stream(extendCreation).forEach(c -> c.accept(res));
        this.dbClient.organizationDao().insert(dbSession, res, false);
        return res;
    }

    private boolean organizationKeyIsUsed(DbSession dbSession, String key) {
        return this.dbClient.organizationDao().selectByKey(dbSession, key).isPresent();
    }

    private void insertDefaultTemplateOnGroups(DbSession dbSession, OrganizationDto organizationDto, GroupDto ownerGroup, GroupDto defaultGroup) {
        Date now = new Date(this.system2.now());
        PermissionTemplateDto permissionTemplateDto = this.dbClient.permissionTemplateDao().insert(dbSession, new PermissionTemplateDto().setOrganizationUuid(organizationDto.getUuid()).setUuid(this.uuidFactory.create()).setName("Default template").setDescription(String.format("Default permission template of organization %s", organizationDto.getName())).setCreatedAt(now).setUpdatedAt(now));
        this.insertGroupPermission(dbSession, permissionTemplateDto, "admin", ownerGroup);
        this.insertGroupPermission(dbSession, permissionTemplateDto, "issueadmin", ownerGroup);
        this.insertGroupPermission(dbSession, permissionTemplateDto, "securityhotspotadmin", ownerGroup);
        this.insertGroupPermission(dbSession, permissionTemplateDto, OrganizationPermission.SCAN.getKey(), ownerGroup);
        this.insertGroupPermission(dbSession, permissionTemplateDto, "user", defaultGroup);
        this.insertGroupPermission(dbSession, permissionTemplateDto, "codeviewer", defaultGroup);
        this.dbClient.organizationDao().setDefaultTemplates(dbSession, organizationDto.getUuid(), new DefaultTemplates().setProjectUuid(permissionTemplateDto.getUuid()));
    }

    private void insertPersonalOrgDefaultTemplate(DbSession dbSession, OrganizationDto organizationDto, GroupDto defaultGroup) {
        long now = this.system2.now();
        Date dateNow = new Date(now);
        PermissionTemplateDto permissionTemplateDto = this.dbClient.permissionTemplateDao().insert(dbSession, new PermissionTemplateDto().setOrganizationUuid(organizationDto.getUuid()).setUuid(this.uuidFactory.create()).setName("Default template").setDescription(String.format("Default permission template of organization %s", organizationDto.getName())).setCreatedAt(dateNow).setUpdatedAt(dateNow));
        this.insertProjectCreatorPermission(dbSession, permissionTemplateDto, "admin", now);
        this.insertProjectCreatorPermission(dbSession, permissionTemplateDto, "issueadmin", now);
        this.insertProjectCreatorPermission(dbSession, permissionTemplateDto, "securityhotspotadmin", now);
        this.insertProjectCreatorPermission(dbSession, permissionTemplateDto, OrganizationPermission.SCAN.getKey(), now);
        this.insertGroupPermission(dbSession, permissionTemplateDto, "user", defaultGroup);
        this.insertGroupPermission(dbSession, permissionTemplateDto, "codeviewer", defaultGroup);
        this.dbClient.organizationDao().setDefaultTemplates(dbSession, organizationDto.getUuid(), new DefaultTemplates().setProjectUuid(permissionTemplateDto.getUuid()));
    }

    private void insertProjectCreatorPermission(DbSession dbSession, PermissionTemplateDto permissionTemplateDto, String permission, long now) {
        this.dbClient.permissionTemplateCharacteristicDao().insert(dbSession, new PermissionTemplateCharacteristicDto().setTemplateId(permissionTemplateDto.getId().longValue()).setWithProjectCreator(true).setPermission(permission).setCreatedAt(now).setUpdatedAt(now));
    }

    private void insertGroupPermission(DbSession dbSession, PermissionTemplateDto template, String permission, @Nullable GroupDto group) {
        this.dbClient.permissionTemplateDao().insertGroupPermission(dbSession, template.getId().longValue(), group == null ? null : group.getId(), permission);
    }

    private void insertQualityProfiles(DbSession dbSession, DbSession batchDbSession, OrganizationDto organization) {
        Map builtInsPerName = (Map)this.builtInQProfileRepository.get().stream().collect(MoreCollectors.uniqueIndex(BuiltInQProfile::getQProfileName));
        ArrayList defaults = new ArrayList();
        this.dbClient.qualityProfileDao().selectBuiltInRuleProfiles(dbSession).forEach(rulesProfile -> {
            OrgQProfileDto dto = new OrgQProfileDto().setOrganizationUuid(organization.getUuid()).setRulesProfileUuid(rulesProfile.getKee()).setUuid(this.uuidFactory.create());
            QProfileName name = new QProfileName(rulesProfile.getLanguage(), rulesProfile.getName());
            BuiltInQProfile builtIn = (BuiltInQProfile)builtInsPerName.get(name);
            if (builtIn == null || builtIn.isDefault()) {
                defaults.add(new DefaultQProfileDto().setQProfileUuid(dto.getUuid()).setOrganizationUuid(organization.getUuid()).setLanguage(rulesProfile.getLanguage()));
            }
            this.dbClient.qualityProfileDao().insert(batchDbSession, dto);
        });
        defaults.forEach(defaultQProfileDto -> this.dbClient.defaultQProfileDao().insertOrUpdate(dbSession, defaultQProfileDto));
    }

    private GroupDto insertOwnersGroup(DbSession dbSession, OrganizationDto organization) {
        GroupDto group = this.dbClient.groupDao().insert(dbSession, new GroupDto().setOrganizationUuid(organization.getUuid()).setName("Owners").setDescription(String.format("Owners of organization %s", organization.getName())));
        this.permissionService.getAllOrganizationPermissions().forEach(p -> this.addPermissionToGroup(dbSession, group, (OrganizationPermission)p));
        return group;
    }

    private void addPermissionToGroup(DbSession dbSession, GroupDto group, OrganizationPermission permission) {
        this.dbClient.groupPermissionDao().insert(dbSession, new GroupPermissionDto().setOrganizationUuid(group.getOrganizationUuid()).setGroupId(group.getId()).setRole(permission.getKey()));
    }

    private void insertUserPermissions(DbSession dbSession, UserDto userDto, OrganizationDto organization, OrganizationPermission permission) {
        this.dbClient.userPermissionDao().insert(dbSession, new UserPermissionDto(organization.getUuid(), permission.getKey(), userDto.getId().intValue(), null));
    }

    private void addCurrentUserToGroup(DbSession dbSession, GroupDto group, int createUserId) {
        this.dbClient.userGroupDao().insert(dbSession, new UserGroupDto().setGroupId(group.getId().intValue()).setUserId(createUserId));
    }

    private void insertOrganizationMember(DbSession dbSession, OrganizationDto organizationDto, int userId) {
        this.dbClient.organizationMemberDao().insert(dbSession, new OrganizationMemberDto().setOrganizationUuid(organizationDto.getUuid()).setUserId(Integer.valueOf(userId)));
    }
}

