/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.Pagination;
import org.sonar.db.alm.OrganizationAlmBindingDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.organization.OrganizationQuery;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Organizations;

public class SearchAction
implements OrganizationsWsAction {
    private static final String PARAM_ORGANIZATIONS = "organizations";
    static final String PARAM_MEMBER = "member";
    private static final String ACTION = "search";
    private static final int MAX_SIZE = 500;
    private final DbClient dbClient;
    private final UserSession userSession;

    public SearchAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(false).setDescription("Search for organizations").setResponseExample(this.getClass().getResource("search-example.json")).setInternal(true).setSince("6.2").setChangelog(new Change[]{new Change("7.5", String.format("Return 'subscription' field when parameter '%s' is set to 'true'", PARAM_MEMBER))}).setChangelog(new Change[]{new Change("7.5", "Removed 'isAdmin' and return 'actions' for each organization")}).setChangelog(new Change[]{new Change("6.4", "Paging fields have been added to the response")}).setHandler((RequestHandler)this);
        action.createParam(PARAM_ORGANIZATIONS).setDescription("Comma-separated list of organization keys").setExampleValue((Object)String.join((CharSequence)",", "my-org-1", "foocorp")).setMaxValuesAllowed(Integer.valueOf(500)).setRequired(false).setSince("6.3");
        action.createParam(PARAM_MEMBER).setDescription("Filter organizations based on whether the authenticated user is a member. If false, no filter applies.").setSince("7.0").setDefaultValue((Object)"false").setBooleanPossibleValues();
        action.addPagingParams(100, 500);
    }

    public void handle(Request request, Response response) throws Exception {
        boolean onlyMembershipOrganizations = request.mandatoryParamAsBoolean(PARAM_MEMBER);
        if (onlyMembershipOrganizations) {
            this.userSession.checkLoggedIn();
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationQuery dbQuery = this.buildDbQuery(request);
            int total = this.dbClient.organizationDao().countByQuery(dbSession, dbQuery);
            Common.Paging paging = SearchAction.buildWsPaging(request, total);
            List organizations = this.dbClient.organizationDao().selectByQuery(dbSession, dbQuery, Pagination.forPage((int)paging.getPageIndex()).andSize(paging.getPageSize()));
            Set<String> adminOrganizationUuids = this.searchOrganizationWithAdminPermission(dbSession);
            Set<String> provisionOrganizationUuids = this.searchOrganizationWithProvisionPermission(dbSession);
            Map organizationAlmBindingByOrgUuid = (Map)this.dbClient.organizationAlmBindingDao().selectByOrganizations(dbSession, (Collection)organizations).stream().collect(MoreCollectors.uniqueIndex(OrganizationAlmBindingDto::getOrganizationUuid));
            Organizations.SearchWsResponse wsResponse = this.buildOrganizations(organizations, adminOrganizationUuids, provisionOrganizationUuids, organizationAlmBindingByOrgUuid, onlyMembershipOrganizations, paging);
            WsUtils.writeProtobuf((Message)wsResponse, request, response);
        }
    }

    private OrganizationQuery buildDbQuery(Request request) {
        return OrganizationQuery.newOrganizationQueryBuilder().setKeys((Collection)request.paramAsStrings(PARAM_ORGANIZATIONS)).setMember(this.getUserIdIfFilterOnMembership(request)).build();
    }

    private Set<String> searchOrganizationWithAdminPermission(DbSession dbSession) {
        Integer userId = this.userSession.getUserId();
        return userId == null ? Collections.emptySet() : (Set)this.dbClient.organizationDao().selectByPermission(dbSession, userId, OrganizationPermission.ADMINISTER.getKey()).stream().map(OrganizationDto::getUuid).collect(MoreCollectors.toSet());
    }

    private Set<String> searchOrganizationWithProvisionPermission(DbSession dbSession) {
        Integer userId = this.userSession.getUserId();
        return userId == null ? Collections.emptySet() : (Set)this.dbClient.organizationDao().selectByPermission(dbSession, userId, OrganizationPermission.PROVISION_PROJECTS.getKey()).stream().map(OrganizationDto::getUuid).collect(MoreCollectors.toSet());
    }

    private Organizations.SearchWsResponse buildOrganizations(List<OrganizationDto> organizations, Set<String> adminOrganizationUuids, Set<String> provisionOrganizationUuids, Map<String, OrganizationAlmBindingDto> organizationAlmBindingByOrgUuid, boolean onlyMembershipOrganizations, Common.Paging paging) {
        Organizations.SearchWsResponse.Builder response = Organizations.SearchWsResponse.newBuilder();
        response.setPaging(paging);
        Organizations.Organization.Builder wsOrganization = Organizations.Organization.newBuilder();
        organizations.forEach(o -> {
            wsOrganization.clear();
            boolean isAdmin = this.userSession.isRoot() || adminOrganizationUuids.contains(o.getUuid());
            boolean canProvision = this.userSession.isRoot() || provisionOrganizationUuids.contains(o.getUuid());
            wsOrganization.setActions(Organizations.Organization.Actions.newBuilder().setAdmin(isAdmin).setProvision(canProvision).setDelete(o.isGuarded() ? this.userSession.isRoot() : isAdmin));
            response.addOrganizations(SearchAction.toOrganization(wsOrganization, o, (OrganizationAlmBindingDto)organizationAlmBindingByOrgUuid.get(o.getUuid()), onlyMembershipOrganizations));
        });
        return response.build();
    }

    private static Organizations.Organization.Builder toOrganization(Organizations.Organization.Builder builder, OrganizationDto organization, @Nullable OrganizationAlmBindingDto organizationAlmBinding, boolean onlyMembershipOrganizations) {
        builder.setName(organization.getName()).setKey(organization.getKey()).setGuarded(organization.isGuarded());
        Optional.ofNullable(organization.getDescription()).ifPresent(arg_0 -> ((Organizations.Organization.Builder)builder).setDescription(arg_0));
        Optional.ofNullable(organization.getUrl()).ifPresent(arg_0 -> ((Organizations.Organization.Builder)builder).setUrl(arg_0));
        Optional.ofNullable(organization.getAvatarUrl()).ifPresent(arg_0 -> ((Organizations.Organization.Builder)builder).setAvatar(arg_0));
        if (onlyMembershipOrganizations && organizationAlmBinding != null) {
            builder.setAlm(Organizations.Organization.Alm.newBuilder().setKey(organizationAlmBinding.getAlm().getId()).setUrl(organizationAlmBinding.getUrl()));
        }
        if (onlyMembershipOrganizations) {
            builder.setSubscription(Organizations.Subscription.valueOf((String)organization.getSubscription().name()));
        }
        return builder;
    }

    private static Common.Paging buildWsPaging(Request request, int total) {
        return Common.Paging.newBuilder().setPageIndex(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).setTotal(total).build();
    }

    @CheckForNull
    private Integer getUserIdIfFilterOnMembership(Request request) {
        boolean filterOnAuthenticatedUser = request.mandatoryParamAsBoolean(PARAM_MEMBER);
        return this.userSession.isLoggedIn() && filterOnAuthenticatedUser ? this.userSession.getUserId() : null;
    }
}

