/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.permission.index.IndexPermissions;

public class PermissionIndexerDao {
    private static final String SQL_TEMPLATE = "SELECT   project_authorization.kind as kind,   project_authorization.project as project,   project_authorization.user_id as user_id,   project_authorization.group_id as group_id,   project_authorization.qualifier as qualifier FROM (       SELECT '" + (Object)((Object)RowKind.USER) + "' as kind,      projects.uuid AS project,       projects.qualifier AS qualifier,       user_roles.user_id  AS user_id,       NULL  AS group_id       FROM projects       INNER JOIN user_roles ON user_roles.resource_id = projects.id AND user_roles.role = 'user'       WHERE         (projects.qualifier = 'TRK'          or  projects.qualifier = 'VW'          or  projects.qualifier = 'APP')         AND projects.copy_component_uuid is NULL         {projectsCondition}       UNION       SELECT '" + (Object)((Object)RowKind.GROUP) + "' as kind,      projects.uuid AS project,       projects.qualifier AS qualifier,       NULL  AS user_id,       groups.id  AS group_id       FROM projects       INNER JOIN group_roles ON group_roles.resource_id = projects.id AND group_roles.role = 'user'       INNER JOIN groups ON groups.id = group_roles.group_id       WHERE         (projects.qualifier = 'TRK'          or  projects.qualifier = 'VW'          or  projects.qualifier = 'APP')         AND projects.copy_component_uuid is NULL         {projectsCondition}         AND group_id IS NOT NULL       UNION       SELECT '" + (Object)((Object)RowKind.ANYONE) + "' as kind,      projects.uuid AS project,       projects.qualifier AS qualifier,       NULL         AS user_id,       NULL     AS group_id       FROM projects       WHERE         (projects.qualifier = 'TRK'          or  projects.qualifier = 'VW'          or  projects.qualifier = 'APP')         AND projects.copy_component_uuid is NULL         AND projects.private = ?         {projectsCondition}       UNION       SELECT '" + (Object)((Object)RowKind.NONE) + "' as kind,      projects.uuid AS project,       projects.qualifier AS qualifier,       NULL AS user_id,       NULL  AS group_id       FROM projects       WHERE         (projects.qualifier = 'TRK'          or  projects.qualifier = 'VW'          or  projects.qualifier = 'APP')         AND projects.copy_component_uuid is NULL         AND projects.private = ?         {projectsCondition}     ) project_authorization";

    List<IndexPermissions> selectAll(DbClient dbClient, DbSession session) {
        return PermissionIndexerDao.doSelectByProjects(dbClient, session, Collections.emptyList());
    }

    List<IndexPermissions> selectByUuids(DbClient dbClient, DbSession session, Collection<String> projectOrViewUuids) {
        return DatabaseUtils.executeLargeInputs(projectOrViewUuids, subProjectOrViewUuids -> PermissionIndexerDao.doSelectByProjects(dbClient, session, subProjectOrViewUuids));
    }

    /*
     * Exception decompiling
     */
    private static List<IndexPermissions> doSelectByProjects(DbClient dbClient, DbSession session, List<String> projectUuids) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static PreparedStatement createStatement(DbClient dbClient, DbSession session, List<String> projectUuids) throws SQLException {
        String sql = projectUuids.isEmpty() ? StringUtils.replace((String)SQL_TEMPLATE, (String)"{projectsCondition}", (String)"") : StringUtils.replace((String)SQL_TEMPLATE, (String)"{projectsCondition}", (String)(" AND projects.uuid in (" + StringUtils.repeat((String)"?", (String)", ", (int)projectUuids.size()) + ")"));
        PreparedStatement stmt = dbClient.getMyBatis().newScrollingSelectStatement(session, sql);
        int index = 1;
        index = PermissionIndexerDao.populateProjectUuidPlaceholders(stmt, projectUuids, index);
        index = PermissionIndexerDao.populateProjectUuidPlaceholders(stmt, projectUuids, index);
        index = PermissionIndexerDao.setPrivateProjectPlaceHolder(stmt, index, false);
        index = PermissionIndexerDao.populateProjectUuidPlaceholders(stmt, projectUuids, index);
        index = PermissionIndexerDao.setPrivateProjectPlaceHolder(stmt, index, true);
        PermissionIndexerDao.populateProjectUuidPlaceholders(stmt, projectUuids, index);
        return stmt;
    }

    private static int populateProjectUuidPlaceholders(PreparedStatement stmt, List<String> projectUuids, int index) throws SQLException {
        int newIndex = index;
        for (String projectUuid : projectUuids) {
            stmt.setString(newIndex, projectUuid);
            ++newIndex;
        }
        return newIndex;
    }

    private static int setPrivateProjectPlaceHolder(PreparedStatement stmt, int index, boolean isPrivate) throws SQLException {
        int newIndex = index;
        stmt.setBoolean(newIndex, isPrivate);
        return ++newIndex;
    }

    private static void processRow(ResultSet rs, Map<String, IndexPermissions> dtosByProjectUuid) throws SQLException {
        RowKind rowKind = RowKind.valueOf(rs.getString(1));
        String projectUuid = rs.getString(2);
        IndexPermissions dto = dtosByProjectUuid.get(projectUuid);
        if (dto == null) {
            String qualifier = rs.getString(5);
            dto = new IndexPermissions(projectUuid, qualifier);
            dtosByProjectUuid.put(projectUuid, dto);
        }
        switch (rowKind) {
            case NONE: {
                break;
            }
            case USER: {
                dto.addUserId(rs.getInt(3));
                break;
            }
            case GROUP: {
                dto.addGroupId(rs.getInt(4));
                break;
            }
            case ANYONE: {
                dto.allowAnyone();
            }
        }
    }

    private static enum RowKind {
        USER,
        GROUP,
        ANYONE,
        NONE;

    }
}

