/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.index;

import java.util.Optional;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.join.query.JoinQueryBuilders;
import org.sonar.api.server.ServerSide;
import org.sonar.db.user.GroupDto;
import org.sonar.server.user.UserSession;

@ServerSide
public class WebAuthorizationTypeSupport {
    private final UserSession userSession;

    public WebAuthorizationTypeSupport(UserSession userSession) {
        this.userSession = userSession;
    }

    public QueryBuilder createQueryFilter() {
        if (this.userSession.isRoot()) {
            return QueryBuilders.matchAllQuery();
        }
        Integer userId = this.userSession.getUserId();
        BoolQueryBuilder filter = QueryBuilders.boolQuery();
        filter.should((QueryBuilder)QueryBuilders.termQuery((String)"auth_allowAnyone", (boolean)true));
        Optional.ofNullable(userId).map(Integer::longValue).ifPresent(id -> filter.should((QueryBuilder)QueryBuilders.termQuery((String)"auth_userIds", (Object)id)));
        this.userSession.getGroups().stream().map(GroupDto::getId).forEach(groupId -> filter.should((QueryBuilder)QueryBuilders.termQuery((String)"auth_groupIds", (Object)groupId)));
        return JoinQueryBuilders.hasParentQuery((String)"auth", (QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)filter), (boolean)false);
    }
}

