/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import com.google.protobuf.Message;
import java.util.Locale;
import org.sonar.api.i18n.I18n;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.permission.PermissionQuery;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.PermissionService;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.WsParameters;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Permissions;

public class SearchGlobalPermissionsAction
implements PermissionsWsAction {
    public static final String ACTION = "search_global_permissions";
    private static final String PROPERTY_PREFIX = "global_permissions.";
    private static final String DESCRIPTION_SUFFIX = ".desc";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final I18n i18n;
    private final PermissionWsSupport wsSupport;
    private final PermissionService permissionService;

    public SearchGlobalPermissionsAction(DbClient dbClient, UserSession userSession, I18n i18n, PermissionWsSupport wsSupport, PermissionService permissionService) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.i18n = i18n;
        this.wsSupport = wsSupport;
        this.permissionService = permissionService;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setDescription("List global permissions. <br />Requires the following permission: 'Administer System'").setResponseExample(this.getClass().getResource("search_global_permissions-example.json")).setSince("5.2").setDeprecatedSince("6.5").setHandler((RequestHandler)this);
        WsParameters.createOrganizationParameter(action).setSince("6.2");
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto org = this.wsSupport.findOrganization(dbSession, wsRequest.param("organization"));
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, org.getUuid());
            Permissions.WsSearchGlobalPermissionsResponse response = this.buildResponse(dbSession, org);
            WsUtils.writeProtobuf((Message)response, wsRequest, wsResponse);
        }
    }

    private Permissions.WsSearchGlobalPermissionsResponse buildResponse(DbSession dbSession, OrganizationDto org) {
        Permissions.WsSearchGlobalPermissionsResponse.Builder response = Permissions.WsSearchGlobalPermissionsResponse.newBuilder();
        Permissions.Permission.Builder permission = Permissions.Permission.newBuilder();
        this.permissionService.getAllOrganizationPermissions().stream().map(OrganizationPermission::getKey).forEach(permissionKey -> {
            PermissionQuery query = SearchGlobalPermissionsAction.permissionQuery(permissionKey, org);
            response.addPermissions(permission.clear().setKey(permissionKey).setName(this.i18nName((String)permissionKey)).setDescription(this.i18nDescriptionMessage((String)permissionKey)).setUsersCount(this.countUsers(dbSession, query)).setGroupsCount(this.countGroups(dbSession, org, (String)permissionKey)));
        });
        return response.build();
    }

    private String i18nDescriptionMessage(String permissionKey) {
        return this.i18n.message(Locale.ENGLISH, PROPERTY_PREFIX + permissionKey + DESCRIPTION_SUFFIX, "", new Object[0]);
    }

    private String i18nName(String permissionKey) {
        return this.i18n.message(Locale.ENGLISH, PROPERTY_PREFIX + permissionKey, permissionKey, new Object[0]);
    }

    private int countGroups(DbSession dbSession, OrganizationDto org, String permission) {
        PermissionQuery query = PermissionQuery.builder().setOrganizationUuid(org.getUuid()).setPermission(permission).build();
        return this.dbClient.groupPermissionDao().countGroupsByQuery(dbSession, query);
    }

    private int countUsers(DbSession dbSession, PermissionQuery permissionQuery) {
        return this.dbClient.userPermissionDao().countUsersByQuery(dbSession, permissionQuery);
    }

    private static PermissionQuery permissionQuery(String permissionKey, OrganizationDto org) {
        return PermissionQuery.builder().setOrganizationUuid(org.getUuid()).setPermission(permissionKey).withAtLeastOnePermission().build();
    }
}

