/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import com.google.common.base.Joiner;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.permission.GlobalPermissions;
import org.sonar.server.permission.PermissionService;

public class WsParameters {
    private final String permissionParamDescription;
    private final String projectPermissionParamDescription;
    private final PermissionService permissionService;

    public WsParameters(PermissionService permissionService) {
        this.permissionService = permissionService;
        String allProjectsPermissionsOnOneLine = Joiner.on((String)", ").join(permissionService.getAllProjectPermissions());
        this.permissionParamDescription = String.format("Permission<ul><li>Possible values for global permissions: %s</li><li>Possible values for project permissions %s</li></ul>", GlobalPermissions.ALL_ON_ONE_LINE, allProjectsPermissionsOnOneLine);
        this.projectPermissionParamDescription = String.format("Permission<ul><li>Possible values for project permissions %s</li></ul>", allProjectsPermissionsOnOneLine);
    }

    public WebService.NewParam createPermissionParameter(WebService.NewAction action) {
        return action.createParam("permission").setDescription(this.permissionParamDescription).setRequired(true);
    }

    public WebService.NewParam createProjectPermissionParameter(WebService.NewAction action, boolean required) {
        return action.createParam("permission").setDescription(this.projectPermissionParamDescription).setPossibleValues(this.permissionService.getAllProjectPermissions()).setRequired(required);
    }

    public WebService.NewParam createProjectPermissionParameter(WebService.NewAction action) {
        return this.createProjectPermissionParameter(action, true);
    }

    public static void createGroupNameParameter(WebService.NewAction action) {
        action.createParam("groupName").setDescription("Group name or 'anyone' (case insensitive)").setExampleValue((Object)"sonar-administrators");
    }

    public static WebService.NewParam createOrganizationParameter(WebService.NewAction action) {
        return action.createParam("organization").setDescription("Key of organization, used when group name is set").setExampleValue((Object)"my-org").setInternal(true);
    }

    public static void createGroupIdParameter(WebService.NewAction action) {
        action.createParam("groupId").setDescription("Group id").setExampleValue((Object)"42");
    }

    public static void createProjectParameters(WebService.NewAction action) {
        action.createParam("projectId").setDescription("Project id").setExampleValue((Object)"ce4c03d6-430f-40a9-b777-ad877c00aa4d");
        WsParameters.createProjectKeyParameter(action);
    }

    private static void createProjectKeyParameter(WebService.NewAction action) {
        action.createParam("projectKey").setDescription("Project key").setExampleValue((Object)"my_project");
    }

    public static void createUserLoginParameter(WebService.NewAction action) {
        action.createParam("login").setRequired(true).setDescription("User login").setExampleValue((Object)"g.hopper");
    }

    public static void createTemplateParameters(WebService.NewAction action) {
        action.createParam("templateId").setDescription("Template id").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        WsParameters.createOrganizationParameter(action);
        action.createParam("templateName").setDescription("Template name").setExampleValue((Object)"Default Permission Template for Projects");
    }

    public static void createTemplateProjectKeyPatternParameter(WebService.NewAction action) {
        action.createParam("projectKeyPattern").setDescription("Project key pattern. Must be a valid Java regular expression").setExampleValue((Object)".*\\.finance\\..*");
    }

    public static void createTemplateDescriptionParameter(WebService.NewAction action) {
        action.createParam("description").setDescription("Description").setExampleValue((Object)"Permissions for all projects related to the financial service");
    }

    public static void createIdParameter(WebService.NewAction action) {
        action.createParam("id").setRequired(true).setDescription("Id").setExampleValue((Object)"af8cb8cc-1e78-4c4e-8c00-ee8e814009a5");
    }
}

