/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration;

import java.util.Date;
import java.util.concurrent.Semaphore;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.logs.Profiler;
import org.sonar.server.platform.Platform;
import org.sonar.server.platform.db.migration.DatabaseMigration;
import org.sonar.server.platform.db.migration.DatabaseMigrationExecutorService;
import org.sonar.server.platform.db.migration.DatabaseMigrationState;
import org.sonar.server.platform.db.migration.MutableDatabaseMigrationState;
import org.sonar.server.platform.db.migration.engine.MigrationEngine;
import org.sonar.server.platform.db.migration.step.MigrationStepExecutionException;

public class DatabaseMigrationImpl
implements DatabaseMigration {
    private static final Logger LOGGER = Loggers.get(DatabaseMigrationImpl.class);
    private final DatabaseMigrationExecutorService executorService;
    private final MigrationEngine migrationEngine;
    private final Platform platform;
    private final MutableDatabaseMigrationState migrationState;
    private final Semaphore semaphore = new Semaphore(1);

    public DatabaseMigrationImpl(DatabaseMigrationExecutorService executorService, MutableDatabaseMigrationState migrationState, MigrationEngine migrationEngine, Platform platform) {
        this.executorService = executorService;
        this.migrationState = migrationState;
        this.migrationEngine = migrationEngine;
        this.platform = platform;
    }

    public void startIt() {
        if (this.semaphore.tryAcquire()) {
            try {
                this.executorService.execute(this::doDatabaseMigration);
            }
            catch (RuntimeException e) {
                this.semaphore.release();
                throw e;
            }
        } else {
            LOGGER.trace("{}: lock is already taken or process is already running", (Object)Thread.currentThread().getName());
        }
    }

    private void doDatabaseMigration() {
        this.migrationState.setStatus(DatabaseMigrationState.Status.RUNNING);
        this.migrationState.setStartedAt(new Date());
        this.migrationState.setError(null);
        Profiler profiler = Profiler.create((Logger)LOGGER);
        try {
            profiler.startInfo("Starting DB Migration and container restart");
            this.doUpgradeDb();
            this.doRestartContainer();
            this.migrationState.setStatus(DatabaseMigrationState.Status.SUCCEEDED);
            profiler.stopInfo("DB Migration and container restart: success");
        }
        catch (MigrationStepExecutionException e) {
            profiler.stopError("DB migration failed", new Object[0]);
            LOGGER.error("DB migration ended with an exception", (Throwable)e);
            this.saveStatus(e);
        }
        catch (Throwable t) {
            profiler.stopError("Container restart failed", new Object[0]);
            LOGGER.error("Container restart failed", t);
            this.saveStatus(t);
        }
        finally {
            this.semaphore.release();
        }
    }

    private void saveStatus(Throwable e) {
        this.migrationState.setStatus(DatabaseMigrationState.Status.FAILED);
        this.migrationState.setError(e);
    }

    private void doUpgradeDb() {
        Profiler profiler = Profiler.createIfTrace((Logger)LOGGER);
        profiler.startTrace("Starting DB Migration");
        this.migrationEngine.execute();
        profiler.stopTrace("DB Migration ended");
    }

    private void doRestartContainer() {
        Profiler profiler = Profiler.createIfTrace((Logger)LOGGER);
        profiler.startTrace("Restarting container");
        this.platform.doStart();
        profiler.stopTrace("Container restarted successfully");
    }
}

