/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.Settings;
import org.sonar.api.server.ServerSide;
import org.sonar.process.ProcessProperties;
import org.sonar.process.systeminfo.Global;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;

@ServerSide
public class SettingsSection
implements SystemInfoSection,
Global {
    private static final int MAX_VALUE_LENGTH = 500;
    private static final String PASSWORD_VALUE = "xxxxxxxx";
    private final Settings settings;

    public SettingsSection(Settings settings) {
        this.settings = settings;
    }

    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder protobuf = ProtobufSystemInfo.Section.newBuilder();
        protobuf.setName("Settings");
        PropertyDefinitions definitions = this.settings.getDefinitions();
        TreeMap orderedProps = new TreeMap(this.settings.getProperties());
        for (Map.Entry prop : orderedProps.entrySet()) {
            String key = (String)prop.getKey();
            String value = SettingsSection.obfuscateValue(definitions, key, (String)prop.getValue());
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)key, (String)value);
        }
        return protobuf.build();
    }

    private static String obfuscateValue(PropertyDefinitions definitions, String key, String value) {
        PropertyDefinition def = definitions.get(key);
        if (def != null && def.type() == PropertyType.PASSWORD) {
            return PASSWORD_VALUE;
        }
        if (StringUtils.endsWithIgnoreCase((String)key, (String)".secured") || StringUtils.containsIgnoreCase((String)key, (String)"password") || StringUtils.containsIgnoreCase((String)key, (String)"passcode") || ProcessProperties.Property.AUTH_JWT_SECRET.getKey().equals(key)) {
            return PASSWORD_VALUE;
        }
        return StringUtils.abbreviate((String)value, (int)500);
    }
}

