/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.platformlevel;

import java.time.Clock;
import java.util.Properties;
import javax.annotation.Nullable;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarQubeVersion;
import org.sonar.api.internal.ApiVersion;
import org.sonar.api.internal.SonarRuntimeImpl;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.internal.TempFolderCleaner;
import org.sonar.core.config.CorePropertyDefinitions;
import org.sonar.core.extension.CoreExtensionRepositoryImpl;
import org.sonar.core.extension.CoreExtensionsInstaller;
import org.sonar.core.extension.CoreExtensionsLoader;
import org.sonar.core.extension.PlatformLevelPredicates;
import org.sonar.core.util.UuidFactoryImpl;
import org.sonar.db.DBSessionsImpl;
import org.sonar.db.DaoModule;
import org.sonar.db.DbClient;
import org.sonar.db.DefaultDatabase;
import org.sonar.db.MyBatis;
import org.sonar.db.purge.PurgeProfiler;
import org.sonar.process.NetworkUtilsImpl;
import org.sonar.process.logging.LogbackHelper;
import org.sonar.server.app.ProcessCommandWrapperImpl;
import org.sonar.server.app.RestartFlagHolderImpl;
import org.sonar.server.app.WebServerProcessLogging;
import org.sonar.server.config.ConfigurationProvider;
import org.sonar.server.es.EsModule;
import org.sonar.server.issue.index.IssueIndex;
import org.sonar.server.permission.index.WebAuthorizationTypeSupport;
import org.sonar.server.platform.LogServerVersion;
import org.sonar.server.platform.Platform;
import org.sonar.server.platform.ServerFileSystemImpl;
import org.sonar.server.platform.TempFolderProvider;
import org.sonar.server.platform.UrlSettings;
import org.sonar.server.platform.WebCoreExtensionsInstaller;
import org.sonar.server.platform.WebServerImpl;
import org.sonar.server.platform.db.EmbeddedDatabaseFactory;
import org.sonar.server.platform.platformlevel.PlatformLevel;
import org.sonar.server.rule.index.RuleIndex;
import org.sonar.server.setting.ThreadLocalSettings;
import org.sonar.server.user.SystemPasscodeImpl;
import org.sonar.server.user.ThreadLocalUserSession;
import org.sonar.server.util.OkHttpClientProvider;

public class PlatformLevel1
extends PlatformLevel {
    private final Platform platform;
    private final Properties properties;
    @Nullable
    private final Object[] extraRootComponents;

    public PlatformLevel1(Platform platform, Properties properties, Object ... extraRootComponents) {
        super("level1");
        this.platform = platform;
        this.properties = properties;
        this.extraRootComponents = extraRootComponents;
    }

    @Override
    public void configureLevel() {
        this.add(this.platform, this.properties);
        this.addExtraRootComponents();
        Version apiVersion = ApiVersion.load((System2)System2.INSTANCE);
        this.add(new SonarQubeVersion(apiVersion), SonarRuntimeImpl.forSonarQube((Version)apiVersion, (SonarQubeSide)SonarQubeSide.SERVER), ThreadLocalSettings.class, new ConfigurationProvider(), LogServerVersion.class, ProcessCommandWrapperImpl.class, RestartFlagHolderImpl.class, UuidFactoryImpl.INSTANCE, NetworkUtilsImpl.INSTANCE, UrlSettings.class, EmbeddedDatabaseFactory.class, LogbackHelper.class, WebServerProcessLogging.class, DefaultDatabase.class, MyBatis.class, PurgeProfiler.class, ServerFileSystemImpl.class, TempFolderCleaner.class, new TempFolderProvider(), System2.INSTANCE, Clock.systemDefaultZone(), ThreadLocalUserSession.class, SystemPasscodeImpl.class, DBSessionsImpl.class, DbClient.class, DaoModule.class, WebAuthorizationTypeSupport.class, EsModule.class, RuleIndex.class, IssueIndex.class, new OkHttpClientProvider(), CoreExtensionRepositoryImpl.class, CoreExtensionsLoader.class, WebCoreExtensionsInstaller.class);
        this.addAll(CorePropertyDefinitions.all());
        this.add(WebServerImpl.class);
    }

    private void addExtraRootComponents() {
        if (this.extraRootComponents != null) {
            for (Object extraRootComponent : this.extraRootComponents) {
                this.add(extraRootComponent);
            }
        }
    }

    @Override
    public PlatformLevel start() {
        this.get(CoreExtensionsLoader.class).load();
        this.get(WebCoreExtensionsInstaller.class).install(this.getContainer(), PlatformLevelPredicates.hasPlatformLevel((int)1), CoreExtensionsInstaller.noAdditionalSideFilter());
        return super.start();
    }
}

