/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.web;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.sonar.api.web.ServletFilter;
import org.sonar.server.platform.Platform;
import org.sonar.server.platform.web.WebPagesCache;

public class WebPagesFilter
implements Filter {
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String CACHE_CONTROL_VALUE = "no-cache, no-store, must-revalidate";
    private static final ServletFilter.UrlPattern URL_PATTERN = ServletFilter.UrlPattern.builder().excludes(ServletFilter.UrlPattern.Builder.staticResourcePatterns()).build();
    private WebPagesCache webPagesCache;

    public WebPagesFilter() {
        this((WebPagesCache)Platform.getInstance().getContainer().getComponentByType(WebPagesCache.class));
    }

    @VisibleForTesting
    WebPagesFilter(WebPagesCache webPagesCache) {
        this.webPagesCache = webPagesCache;
    }

    public void init(FilterConfig filterConfig) {
        this.webPagesCache.init(filterConfig.getServletContext());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String path = httpServletRequest.getRequestURI().replaceFirst(httpServletRequest.getContextPath(), "");
        if (!URL_PATTERN.matches(path)) {
            chain.doFilter(request, response);
            return;
        }
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name().toLowerCase(Locale.ENGLISH));
        httpServletResponse.setHeader(CACHE_CONTROL_HEADER, CACHE_CONTROL_VALUE);
        String htmlContent = Objects.requireNonNull(this.webPagesCache.getContent(path));
        IOUtils.write((String)htmlContent, (OutputStream)httpServletResponse.getOutputStream(), (Charset)StandardCharsets.UTF_8);
    }

    public void destroy() {
    }
}

