/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.server.platform.ws.SystemInfoWriter;
import org.sonar.server.platform.ws.SystemWsAction;
import org.sonar.server.user.UserSession;

public class InfoAction
implements SystemWsAction {
    private final SystemInfoWriter systemInfoWriter;
    private final UserSession userSession;

    public InfoAction(UserSession userSession, SystemInfoWriter systemInfoWriter) {
        this.userSession = userSession;
        this.systemInfoWriter = systemInfoWriter;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("info").setDescription("Get detailed information about system configuration.<br/>Requires 'Administer' permissions.").setSince("5.1").setInternal(true).setResponseExample(this.getClass().getResource("info-example.json")).setHandler((RequestHandler)this);
        action.setChangelog(new Change[]{new Change("5.5", "Becomes internal to easily update result")});
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        JsonWriter json = response.newJsonWriter();
        json.beginObject();
        this.systemInfoWriter.write(json);
        json.endObject();
        json.close();
    }
}

