/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.process.ProcessId;
import org.sonar.server.log.ServerLogging;
import org.sonar.server.platform.ws.SystemWsAction;
import org.sonar.server.user.UserSession;

public class LogsAction
implements SystemWsAction {
    private static final String PROCESS_PROPERTY = "process";
    private final UserSession userSession;
    private final ServerLogging serverLogging;

    public LogsAction(UserSession userSession, ServerLogging serverLogging) {
        this.userSession = userSession;
        this.serverLogging = serverLogging;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("logs").setDescription("Get system logs in plain-text format. Requires system administration permission.").setResponseExample(this.getClass().getResource("logs-example.log")).setSince("5.2").setHandler((RequestHandler)this);
        action.createParam(PROCESS_PROPERTY).setPossibleValues((Collection)Arrays.stream(ProcessId.values()).map(ProcessId::getKey).sorted().collect(MoreCollectors.toList((int)ProcessId.values().length))).setDefaultValue((Object)ProcessId.APP.getKey()).setSince("6.2").setDescription("Process to get logs from");
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        this.userSession.checkIsSystemAdministrator();
        String processKey = wsRequest.mandatoryParam(PROCESS_PROPERTY);
        ProcessId processId = ProcessId.fromKey((String)processKey);
        File logsDir = this.serverLogging.getLogsDir();
        File file = new File(logsDir, processId.getLogFilenamePrefix() + ".log");
        if (file.exists() && file.getParentFile().equals(logsDir)) {
            wsResponse.stream().setMediaType("text/plain");
            FileUtils.copyFile((File)file, (OutputStream)wsResponse.stream().output());
        } else {
            wsResponse.stream().setStatus(404);
        }
    }
}

