/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import java.util.Collection;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;
import org.sonar.server.health.Health;
import org.sonar.server.telemetry.TelemetryDataJsonWriter;
import org.sonar.server.telemetry.TelemetryDataLoader;

public abstract class SystemInfoWriter {
    private static final String[] ORDERED_SECTION_NAMES = new String[]{"System", "Database", "Plugins", "Web JVM State", "Web Database Connection", "Web Logging", "Web JVM Properties", "Compute Engine Tasks", "Compute Engine JVM State", "Compute Engine Database Connection", "Compute Engine Logging", "Compute Engine JVM Properties", "Search State", "Search Indexes"};
    private final TelemetryDataLoader telemetry;

    SystemInfoWriter(TelemetryDataLoader telemetry) {
        this.telemetry = telemetry;
    }

    public abstract void write(JsonWriter var1) throws Exception;

    protected void writeSections(Collection<ProtobufSystemInfo.Section> sections, JsonWriter json) {
        SystemInfoUtils.order(sections, (String[])ORDERED_SECTION_NAMES).forEach(section -> this.writeSection((ProtobufSystemInfo.Section)section, json));
    }

    private void writeSection(ProtobufSystemInfo.Section section, JsonWriter json) {
        json.name(section.getName());
        json.beginObject();
        for (ProtobufSystemInfo.Attribute attribute : section.getAttributesList()) {
            this.writeAttribute(attribute, json);
        }
        json.endObject();
    }

    private void writeAttribute(ProtobufSystemInfo.Attribute attribute, JsonWriter json) {
        switch (attribute.getValueCase()) {
            case BOOLEAN_VALUE: {
                json.prop(attribute.getKey(), attribute.getBooleanValue());
                break;
            }
            case LONG_VALUE: {
                json.prop(attribute.getKey(), attribute.getLongValue());
                break;
            }
            case DOUBLE_VALUE: {
                json.prop(attribute.getKey(), attribute.getDoubleValue());
                break;
            }
            case STRING_VALUE: {
                json.prop(attribute.getKey(), attribute.getStringValue());
                break;
            }
            case VALUE_NOT_SET: {
                json.name(attribute.getKey()).beginArray().values((Iterable)attribute.getStringValuesList()).endArray();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + attribute.getValueCase());
            }
        }
    }

    protected void writeHealth(Health health, JsonWriter json) {
        json.prop("Health", health.getStatus().name());
        json.name("Health Causes").beginArray().values(health.getCauses()).endArray();
    }

    protected void writeTelemetry(JsonWriter json) {
        json.name("Statistics");
        TelemetryDataJsonWriter.writeTelemetryData(json, this.telemetry.load());
    }
}

