/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import com.google.common.base.Optional;
import com.google.common.io.Resources;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.server.platform.ws.SystemWsAction;
import org.sonar.server.plugins.UpdateCenterMatrixFactory;
import org.sonar.server.plugins.ws.PluginWSCommons;
import org.sonar.server.ui.VersionFormatter;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.SonarUpdate;
import org.sonar.updatecenter.common.UpdateCenter;

public class UpgradesAction
implements SystemWsAction {
    private static final boolean DO_NOT_FORCE_REFRESH = false;
    private static final String ARRAY_UPGRADES = "upgrades";
    private static final String PROPERTY_UPDATE_CENTER_REFRESH = "updateCenterRefresh";
    private static final String PROPERTY_VERSION = "version";
    private static final String PROPERTY_DESCRIPTION = "description";
    private static final String PROPERTY_RELEASE_DATE = "releaseDate";
    private static final String PROPERTY_CHANGE_LOG_URL = "changeLogUrl";
    private static final String PROPERTY_DOWNLOAD_URL = "downloadUrl";
    private static final String OBJECT_PLUGINS = "plugins";
    private static final String ARRAY_REQUIRE_UPDATE = "requireUpdate";
    private static final String ARRAY_INCOMPATIBLE = "incompatible";
    private final UpdateCenterMatrixFactory updateCenterFactory;

    public UpgradesAction(UpdateCenterMatrixFactory updateCenterFactory) {
        this.updateCenterFactory = updateCenterFactory;
    }

    private static void writeMetadata(JsonWriter jsonWriter, Release release) {
        jsonWriter.prop(PROPERTY_VERSION, VersionFormatter.format(release.getVersion().getName()));
        jsonWriter.prop(PROPERTY_DESCRIPTION, release.getDescription());
        jsonWriter.propDate(PROPERTY_RELEASE_DATE, release.getDate());
        jsonWriter.prop(PROPERTY_CHANGE_LOG_URL, release.getChangelogUrl());
        jsonWriter.prop(PROPERTY_DOWNLOAD_URL, release.getDownloadUrl());
    }

    public void define(WebService.NewController controller) {
        controller.createAction(ARRAY_UPGRADES).setDescription("Lists available upgrades for the SonarQube instance (if any) and for each one, lists incompatible plugins and plugins requiring upgrade.<br/>Plugin information is retrieved from Update Center. Date and time at which Update Center was last refreshed is provided in the response.").setSince("5.2").setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"example-upgrades_plugins.json"));
    }

    public void handle(Request request, Response response) throws Exception {
        try (JsonWriter jsonWriter = response.newJsonWriter();){
            jsonWriter.setSerializeEmptys(false);
            this.writeResponse(jsonWriter);
        }
    }

    private void writeResponse(JsonWriter jsonWriter) {
        jsonWriter.beginObject();
        Optional<UpdateCenter> updateCenter = this.updateCenterFactory.getUpdateCenter(false);
        UpgradesAction.writeUpgrades(jsonWriter, updateCenter);
        if (updateCenter.isPresent()) {
            jsonWriter.propDateTime(PROPERTY_UPDATE_CENTER_REFRESH, ((UpdateCenter)updateCenter.get()).getDate());
        }
        jsonWriter.endObject();
    }

    private static void writeUpgrades(JsonWriter jsonWriter, Optional<UpdateCenter> updateCenter) {
        jsonWriter.name(ARRAY_UPGRADES).beginArray();
        if (updateCenter.isPresent()) {
            for (SonarUpdate sonarUpdate : ((UpdateCenter)updateCenter.get()).findSonarUpdates()) {
                UpgradesAction.writeUpgrade(jsonWriter, sonarUpdate);
            }
        }
        jsonWriter.endArray();
    }

    private static void writeUpgrade(JsonWriter jsonWriter, SonarUpdate sonarUpdate) {
        jsonWriter.beginObject();
        UpgradesAction.writeMetadata(jsonWriter, sonarUpdate.getRelease());
        UpgradesAction.writePlugins(jsonWriter, sonarUpdate);
        jsonWriter.endObject();
    }

    private static void writePlugins(JsonWriter jsonWriter, SonarUpdate sonarUpdate) {
        jsonWriter.name(OBJECT_PLUGINS).beginObject();
        UpgradesAction.writePluginsToUpdate(jsonWriter, sonarUpdate.getPluginsToUpgrade());
        UpgradesAction.writeIncompatiblePlugins(jsonWriter, sonarUpdate.getIncompatiblePlugins());
        jsonWriter.endObject();
    }

    private static void writePluginsToUpdate(JsonWriter jsonWriter, List<Release> pluginsToUpgrade) {
        jsonWriter.name(ARRAY_REQUIRE_UPDATE).beginArray();
        for (Release release : pluginsToUpgrade) {
            jsonWriter.beginObject();
            PluginWSCommons.writePlugin(jsonWriter, (Plugin)release.getArtifact());
            String version = StringUtils.isNotBlank((String)release.getDisplayVersion()) ? release.getDisplayVersion() : release.getVersion().toString();
            jsonWriter.prop(PROPERTY_VERSION, version);
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
    }

    private static void writeIncompatiblePlugins(JsonWriter jsonWriter, List<Plugin> incompatiblePlugins) {
        jsonWriter.name(ARRAY_INCOMPATIBLE).beginArray();
        for (Plugin incompatiblePlugin : incompatiblePlugins) {
            jsonWriter.beginObject();
            PluginWSCommons.writePlugin(jsonWriter, incompatiblePlugin);
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
    }
}

