/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins.ws;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.plugins.InstalledPlugin;
import org.sonar.server.plugins.PluginFileSystem;
import org.sonar.server.plugins.ws.PluginsWsAction;

public class DownloadAction
implements PluginsWsAction {
    private static final String PACK200 = "pack200";
    private static final String ACCEPT_COMPRESSIONS_PARAM = "acceptCompressions";
    private static final String PLUGIN_PARAM = "plugin";
    private final PluginFileSystem pluginFileSystem;

    public DownloadAction(PluginFileSystem pluginFileSystem) {
        this.pluginFileSystem = pluginFileSystem;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("download").setSince("7.2").setDescription("Download plugin JAR, for usage by scanner engine").setInternal(true).setHandler((RequestHandler)this);
        action.createParam(PLUGIN_PARAM).setRequired(true).setDescription("The key identifying the plugin to download").setExampleValue((Object)"cobol");
        action.createParam(ACCEPT_COMPRESSIONS_PARAM).setExampleValue((Object)PACK200);
    }

    public void handle(Request request, Response response) throws Exception {
        InstalledPlugin.FileAndMd5 downloadedFile;
        String pluginKey = request.mandatoryParam(PLUGIN_PARAM);
        Optional<InstalledPlugin> file = this.pluginFileSystem.getInstalledPlugin(pluginKey);
        if (!file.isPresent()) {
            throw new NotFoundException("Plugin " + pluginKey + " not found");
        }
        InstalledPlugin.FileAndMd5 compressedJar = file.get().getCompressedJar();
        if (compressedJar != null && PACK200.equals(request.param(ACCEPT_COMPRESSIONS_PARAM))) {
            response.stream().setMediaType("application/octet-stream");
            response.setHeader("Sonar-Compression", PACK200);
            response.setHeader("Sonar-UncompressedMD5", file.get().getLoadedJar().getMd5());
            downloadedFile = compressedJar;
        } else {
            response.stream().setMediaType("application/java-archive");
            downloadedFile = file.get().getLoadedJar();
        }
        response.setHeader("Sonar-MD5", downloadedFile.getMd5());
        try (FileInputStream input = FileUtils.openInputStream((File)downloadedFile.getFile());){
            IOUtils.copyLarge((InputStream)input, (OutputStream)response.stream().output());
        }
    }
}

