/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import java.util.Optional;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.project.Visibility;
import org.sonar.server.project.ws.ProjectsWsAction;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class UpdateDefaultVisibilityAction
implements ProjectsWsAction {
    static final String ACTION = "update_default_visibility";
    static final String PARAM_PROJECT_VISIBILITY = "projectVisibility";
    private final UserSession userSession;
    private final DbClient dbClient;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public UpdateDefaultVisibilityAction(UserSession userSession, DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(true).setDescription("Update the default visibility for new projects.<br/>Requires System Administrator privileges").setChangelog(new Change[]{new Change("7.3", "This WS used to be located at /api/organizations/update_project_visibility")}).setInternal(true).setSince("6.4").setHandler((RequestHandler)this);
        action.createParam(PARAM_PROJECT_VISIBILITY).setRequired(true).setDescription("Default visibility for projects").setPossibleValues(Visibility.getLabels());
    }

    public void handle(Request request, Response response) throws Exception {
        boolean newProjectsPrivate = Visibility.isPrivate(request.mandatoryParam(PARAM_PROJECT_VISIBILITY));
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional optionalOrganization = this.dbClient.organizationDao().selectByKey(dbSession, this.defaultOrganizationProvider.get().getKey());
            OrganizationDto organization = (OrganizationDto)WsUtils.checkFoundWithOptional(optionalOrganization, "No default organization.", new Object[0]);
            if (!this.userSession.isSystemAdministrator()) {
                throw AbstractUserSession.insufficientPrivilegesException();
            }
            this.dbClient.organizationDao().setNewProjectPrivate(dbSession, organization, newProjectsPrivate);
            dbSession.commit();
        }
        response.noContent();
    }
}

