/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectanalysis.ws;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.sonar.db.event.EventDto;
import org.sonar.server.projectanalysis.ws.EventCategory;

class EventValidator {
    private static final Set<String> AUTHORIZED_CATEGORIES = ImmutableSet.of((Object)EventCategory.VERSION.name(), (Object)EventCategory.OTHER.name());
    private static final String AUTHORIZED_CATEGORIES_INLINED = Joiner.on((String)", ").join(AUTHORIZED_CATEGORIES);

    private EventValidator() {
    }

    static Consumer<EventDto> checkModifiable() {
        return event -> Preconditions.checkArgument((boolean)AUTHORIZED_CATEGORIES.contains(EventCategory.fromLabel(event.getCategory()).name()), (String)"Event of category '%s' cannot be modified. Authorized categories: %s", (Object[])new Object[]{EventCategory.fromLabel(event.getCategory()), AUTHORIZED_CATEGORIES_INLINED});
    }

    static void checkVersionName(EventCategory category, @Nullable String name) {
        EventValidator.checkVersionName(category.getLabel(), name);
    }

    static void checkVersionName(@Nullable String category, @Nullable String name) {
        if (EventCategory.VERSION.getLabel().equals(category) && name != null) {
            Preconditions.checkArgument((name.length() <= 100 ? 1 : 0) != 0, (String)"Event name length (%s) is longer than the maximum authorized (%s). '%s' was provided.", (Object[])new Object[]{name.length(), 100, name});
        }
    }
}

