/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.sonar.server.qualitygate.Condition;
import org.sonar.server.qualitygate.EvaluatedCondition;
import org.sonar.server.qualitygate.EvaluatedQualityGate;

public class QualityGateConverter {
    private static final String FIELD_LEVEL = "level";
    private static final String FIELD_IGNORED_CONDITIONS = "ignoredConditions";

    private QualityGateConverter() {
    }

    public static String toJson(EvaluatedQualityGate gate) {
        JsonObject details = new JsonObject();
        details.addProperty(FIELD_LEVEL, gate.getStatus().name());
        JsonArray conditionResults = new JsonArray();
        for (EvaluatedCondition condition : gate.getEvaluatedConditions()) {
            conditionResults.add((JsonElement)QualityGateConverter.toJson(condition));
        }
        details.add("conditions", (JsonElement)conditionResults);
        details.addProperty(FIELD_IGNORED_CONDITIONS, Boolean.valueOf(gate.hasIgnoredConditionsOnSmallChangeset()));
        return details.toString();
    }

    private static JsonObject toJson(EvaluatedCondition evaluatedCondition) {
        Condition condition = evaluatedCondition.getCondition();
        JsonObject result = new JsonObject();
        result.addProperty("metric", condition.getMetricKey());
        result.addProperty("op", condition.getOperator().getDbValue());
        if (condition.isOnLeakPeriod()) {
            result.addProperty("period", (Number)1);
        }
        result.addProperty("error", condition.getErrorThreshold());
        evaluatedCondition.getValue().ifPresent(v -> result.addProperty("actual", v));
        result.addProperty(FIELD_LEVEL, evaluatedCondition.getStatus().name());
        return result;
    }
}

