/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Preconditions;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;

public class DeleteConditionAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final QualityGatesWsSupport wsSupport;

    public DeleteConditionAction(DbClient dbClient, QualityGatesWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction createCondition = controller.createAction("delete_condition").setDescription("Delete a condition from a quality gate.<br>Requires the 'Administer Quality Gates' permission.").setPost(true).setSince("4.3").setHandler((RequestHandler)this);
        createCondition.createParam("id").setRequired(true).setDescription("Condition ID").setExampleValue((Object)"2");
        this.wsSupport.createOrganizationParam(createCondition);
    }

    public void handle(Request request, Response response) {
        long conditionId = request.mandatoryParamAsLong("id");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, request);
            QualityGateConditionDto condition = this.wsSupport.getCondition(dbSession, conditionId);
            QGateWithOrgDto qualityGateDto = this.dbClient.qualityGateDao().selectByOrganizationAndId(dbSession, organization, condition.getQualityGateId());
            Preconditions.checkState((qualityGateDto != null ? 1 : 0) != 0, (String)"Condition '%s' is linked to an unknown quality gate '%s'", (Object[])new Object[]{conditionId, condition.getQualityGateId()});
            this.wsSupport.checkCanEdit(qualityGateDto);
            this.dbClient.gateConditionDao().delete(condition, dbSession);
            dbSession.commit();
            response.noContent();
        }
    }
}

