/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.WebService;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.qualitygate.Condition;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.ws.RemovedWebServiceHandler;

public class QualityGatesWs
implements WebService {
    private static final int CONDITION_MAX_LENGTH = 64;
    private final QualityGatesWsAction[] actions;

    public QualityGatesWs(QualityGatesWsAction ... actions) {
        this.actions = actions;
    }

    public void define(WebService.Context context) {
        WebService.NewController controller = context.createController("api/qualitygates").setSince("4.3").setDescription("Manage quality gates, including conditions and project association.");
        for (QualityGatesWsAction action : this.actions) {
            action.define(controller);
        }
        controller.createAction("unset_default").setDescription("This webservice is no more available : a default quality gate is mandatory.").setSince("4.3").setDeprecatedSince("7.0").setPost(true).setHandler((RequestHandler)RemovedWebServiceHandler.INSTANCE).setResponseExample(RemovedWebServiceHandler.INSTANCE.getResponseExample()).setChangelog(new Change[]{new Change("7.0", "Unset a quality gate is no more authorized")});
        controller.done();
    }

    static void addConditionParams(WebService.NewAction action) {
        action.createParam("metric").setDescription("Condition metric.<br/> Only metric of the following types are allowed:<ul><li>INT</li><li>MILLISEC</li><li>RATING</li><li>WORK_DUR</li><li>FLOAT</li><li>PERCENT</li><li>LEVEL</li>").setRequired(true).setExampleValue((Object)"blocker_violations");
        action.createParam("op").setDescription("Condition operator:<br/><ul><li>LT = is lower than</li><li>GT = is greater than</li></ui>").setExampleValue((Object)Condition.Operator.GREATER_THAN.getDbValue()).setPossibleValues(QualityGatesWs.getPossibleOperators());
        action.createParam("error").setMaximumLength(Integer.valueOf(64)).setDescription("Condition error threshold").setRequired(true).setExampleValue((Object)"10");
    }

    static Long parseId(Request request, String paramName) {
        try {
            return Long.valueOf(request.mandatoryParam(paramName));
        }
        catch (NumberFormatException badFormat) {
            throw BadRequestException.create(paramName + " must be a valid long value");
        }
    }

    private static Set<String> getPossibleOperators() {
        return Stream.of(Condition.Operator.values()).map(Condition.Operator::getDbValue).collect(Collectors.toSet());
    }
}

