/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualitygates;

public class QualityGatesWsSupport {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public QualityGatesWsSupport(DbClient dbClient, UserSession userSession, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public QGateWithOrgDto getByOrganizationAndId(DbSession dbSession, OrganizationDto organization, long qualityGateId) {
        return WsUtils.checkFound(this.dbClient.qualityGateDao().selectByOrganizationAndId(dbSession, organization, qualityGateId), "No quality gate has been found for id %s in organization %s", qualityGateId, organization.getName());
    }

    QualityGateConditionDto getCondition(DbSession dbSession, long id) {
        return WsUtils.checkFound(this.dbClient.gateConditionDao().selectById(id, dbSession), "No quality gate condition with id '%d'", id);
    }

    boolean isQualityGateAdmin(OrganizationDto organization) {
        return this.userSession.hasPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, organization);
    }

    WebService.NewParam createOrganizationParam(WebService.NewAction action) {
        return action.createParam("organization").setDescription("Organization key. If no organization is provided, the default organization is used.").setSince("7.0").setRequired(false).setInternal(false).setExampleValue((Object)"my-org");
    }

    Qualitygates.Actions getActions(OrganizationDto organization, QualityGateDto qualityGate, @Nullable QualityGateDto defaultQualityGate) {
        Long defaultId = defaultQualityGate == null ? null : defaultQualityGate.getId();
        boolean isDefault = qualityGate.getId().equals(defaultId);
        boolean isBuiltIn = qualityGate.isBuiltIn();
        boolean isQualityGateAdmin = this.isQualityGateAdmin(organization);
        return Qualitygates.Actions.newBuilder().setCopy(isQualityGateAdmin).setRename(!isBuiltIn && isQualityGateAdmin).setManageConditions(!isBuiltIn && isQualityGateAdmin).setDelete(!isDefault && !isBuiltIn && isQualityGateAdmin).setSetAsDefault(!isDefault && isQualityGateAdmin).setAssociateProjects(!isDefault && isQualityGateAdmin).build();
    }

    OrganizationDto getOrganization(DbSession dbSession, Request request) {
        String organizationKey = Optional.ofNullable(request.param("organization")).orElseGet(() -> this.defaultOrganizationProvider.get().getKey());
        Optional organizationDto = this.dbClient.organizationDao().selectByKey(dbSession, organizationKey);
        OrganizationDto organization = (OrganizationDto)WsUtils.checkFoundWithOptional(organizationDto, "No organization with key '%s'", organizationKey);
        this.checkMembershipOnPaidOrganization(organization);
        return organization;
    }

    void checkCanEdit(QGateWithOrgDto qualityGate) {
        QualityGatesWsSupport.checkNotBuiltIn((QualityGateDto)qualityGate);
        this.userSession.checkPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, qualityGate.getOrganizationUuid());
    }

    void checkCanAdminProject(OrganizationDto organization, ComponentDto project) {
        if (this.userSession.hasPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, organization) || this.userSession.hasComponentPermission("admin", project)) {
            return;
        }
        throw AbstractUserSession.insufficientPrivilegesException();
    }

    void checkProjectBelongsToOrganization(OrganizationDto organization, ComponentDto project) {
        if (project.getOrganizationUuid().equals(organization.getUuid())) {
            return;
        }
        throw new NotFoundException(String.format("Project '%s' doesn't exist in organization '%s'", project.getKey(), organization.getKey()));
    }

    private static void checkNotBuiltIn(QualityGateDto qualityGate) {
        Preconditions.checkArgument((!qualityGate.isBuiltIn() ? 1 : 0) != 0, (String)"Operation forbidden for built-in Quality Gate '%s'", (Object[])new Object[]{qualityGate.getName()});
    }

    private void checkMembershipOnPaidOrganization(OrganizationDto organization) {
        if (!organization.getSubscription().equals((Object)OrganizationDto.Subscription.PAID)) {
            return;
        }
        this.userSession.checkMembership(organization);
    }
}

