/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.qualitygate.ws.QualityGatesWs;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualitygates;

public class RenameAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final QualityGatesWsSupport wsSupport;

    public RenameAction(DbClient dbClient, QualityGatesWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("rename").setPost(true).setDescription("Rename a Quality Gate.<br>Requires the 'Administer Quality Gates' permission.").setSince("4.3").setHandler((RequestHandler)this);
        action.createParam("id").setRequired(true).setDescription("ID of the quality gate to rename").setExampleValue((Object)"1");
        action.createParam("name").setRequired(true).setMaximumLength(Integer.valueOf(100)).setDescription("New name of the quality gate").setExampleValue((Object)"My Quality Gate");
        this.wsSupport.createOrganizationParam(action);
    }

    public void handle(Request request, Response response) {
        long id = QualityGatesWs.parseId(request, "id");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, request);
            QualityGateDto qualityGate = this.rename(dbSession, organization, id, request.mandatoryParam("name"));
            WsUtils.writeProtobuf((Message)Qualitygates.QualityGate.newBuilder().setId(qualityGate.getId().longValue()).setName(qualityGate.getName()).build(), request, response);
        }
    }

    private QualityGateDto rename(DbSession dbSession, OrganizationDto organization, long id, String name) {
        QGateWithOrgDto qualityGate = this.wsSupport.getByOrganizationAndId(dbSession, organization, id);
        this.wsSupport.checkCanEdit(qualityGate);
        this.checkNotAlreadyExists(dbSession, organization, (QualityGateDto)qualityGate, name);
        qualityGate.setName(name);
        this.dbClient.qualityGateDao().update((QualityGateDto)qualityGate, dbSession);
        dbSession.commit();
        return qualityGate;
    }

    private void checkNotAlreadyExists(DbSession dbSession, OrganizationDto organization, QualityGateDto qualityGate, String name) {
        QGateWithOrgDto existingQgate = this.dbClient.qualityGateDao().selectByOrganizationAndName(dbSession, organization, name);
        boolean isModifyingCurrentQgate = existingQgate == null || existingQgate.getId().equals(qualityGate.getId());
        Preconditions.checkArgument((boolean)isModifyingCurrentQgate, (String)"Name '%s' has already been taken", (Object[])new Object[]{name});
    }
}

