/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.property.PropertyDto;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;

public class SelectAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;
    private final QualityGatesWsSupport wsSupport;

    public SelectAction(DbClient dbClient, ComponentFinder componentFinder, QualityGatesWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("select").setDescription("Associate a project to a quality gate.<br>The '%s' or '%s' must be provided.<br>Project id as a numeric value is deprecated since 6.1. Please use the id similar to '%s'.<br>Requires the 'Administer Quality Gates' permission.", new Object[]{"projectId", "projectKey", "AU-TpxcA-iU5OvuD2FLz"}).setPost(true).setSince("4.3").setHandler((RequestHandler)this);
        action.createParam("gateId").setDescription("Quality gate id").setRequired(true).setExampleValue((Object)"1");
        action.createParam("projectId").setDescription("Project id. Project id as an numeric value is deprecated since 6.1").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("projectKey").setDescription("Project key").setExampleValue((Object)"my_project").setSince("6.1");
        this.wsSupport.createOrganizationParam(action);
    }

    public void handle(Request request, Response response) {
        long gateId = request.mandatoryParamAsLong("gateId");
        String projectId = request.param("projectId");
        String projectKey = request.param("projectKey");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, request);
            QGateWithOrgDto qualityGate = this.wsSupport.getByOrganizationAndId(dbSession, organization, gateId);
            ComponentDto project = this.getProject(dbSession, organization, projectId, projectKey);
            this.wsSupport.checkCanAdminProject(organization, project);
            this.dbClient.propertiesDao().saveProperty(dbSession, new PropertyDto().setKey("sonar.qualitygate").setResourceId(project.getId()).setValue(String.valueOf(qualityGate.getId())));
            dbSession.commit();
        }
        response.noContent();
    }

    private ComponentDto getProject(DbSession dbSession, OrganizationDto organization, @Nullable String projectId, @Nullable String projectKey) {
        ComponentDto project = this.selectProjectById(dbSession, projectId).orElseGet(() -> this.componentFinder.getByUuidOrKey(dbSession, projectId, projectKey, ComponentFinder.ParamNames.PROJECT_ID_AND_KEY));
        this.wsSupport.checkProjectBelongsToOrganization(organization, project);
        return project;
    }

    private Optional<ComponentDto> selectProjectById(DbSession dbSession, @Nullable String projectId) {
        if (projectId == null) {
            return Optional.empty();
        }
        try {
            long dbId = Long.parseLong(projectId);
            return Optional.ofNullable(this.dbClient.componentDao().selectById(dbSession, dbId).orElse(null));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }
}

