/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.qualitygate.QGateWithOrgDto;
import org.sonar.server.qualitygate.ws.QualityGatesWs;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;
import org.sonar.server.user.UserSession;

public class SetAsDefaultAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final QualityGatesWsSupport wsSupport;

    public SetAsDefaultAction(DbClient dbClient, UserSession userSession, QualityGatesWsSupport qualityGatesWsSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.wsSupport = qualityGatesWsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("set_as_default").setDescription("Set a quality gate as the default quality gate.<br>Requires the 'Administer Quality Gates' permission.").setSince("4.3").setPost(true).setHandler((RequestHandler)this);
        action.createParam("id").setDescription("ID of the quality gate to set as default").setRequired(true).setExampleValue((Object)"1");
        this.wsSupport.createOrganizationParam(action);
    }

    public void handle(Request request, Response response) {
        Long id = QualityGatesWs.parseId(request, "id");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, request);
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER_QUALITY_GATES, organization);
            QGateWithOrgDto qualityGate = this.wsSupport.getByOrganizationAndId(dbSession, organization, id);
            organization.setDefaultQualityGateUuid(qualityGate.getUuid());
            this.dbClient.organizationDao().update(dbSession, organization);
            dbSession.commit();
        }
        response.noContent();
    }
}

